package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.workdocs.model.primitives.IdType
import scala.jdk.CollectionConverters.*
final case class SharePrincipal(
    id: IdType,
    `type`: zio.aws.workdocs.model.PrincipalType,
    role: zio.aws.workdocs.model.RoleType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.SharePrincipal = {
    import SharePrincipal.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.SharePrincipal
      .builder()
      .id(IdType.unwrap(id): java.lang.String)
      .`type`(`type`.unwrap)
      .role(role.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.SharePrincipal.ReadOnly =
    zio.aws.workdocs.model.SharePrincipal.wrap(buildAwsValue())
}
object SharePrincipal {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.SharePrincipal
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.SharePrincipal =
      zio.aws.workdocs.model.SharePrincipal(id, `type`, role)
    def id: IdType
    def `type`: zio.aws.workdocs.model.PrincipalType
    def role: zio.aws.workdocs.model.RoleType
    def getId: ZIO[Any, Nothing, IdType] = ZIO.succeed(id)
    def getType: ZIO[Any, Nothing, zio.aws.workdocs.model.PrincipalType] =
      ZIO.succeed(`type`)
    def getRole: ZIO[Any, Nothing, zio.aws.workdocs.model.RoleType] =
      ZIO.succeed(role)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.SharePrincipal
  ) extends zio.aws.workdocs.model.SharePrincipal.ReadOnly {
    override val id: IdType =
      zio.aws.workdocs.model.primitives.IdType(impl.id())
    override val `type`: zio.aws.workdocs.model.PrincipalType =
      zio.aws.workdocs.model.PrincipalType.wrap(impl.`type`())
    override val role: zio.aws.workdocs.model.RoleType =
      zio.aws.workdocs.model.RoleType.wrap(impl.role())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.SharePrincipal
  ): zio.aws.workdocs.model.SharePrincipal.ReadOnly = new Wrapper(impl)
}
