package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{LimitType, PageMarkerType, IdType}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeNotificationSubscriptionsRequest(
    organizationId: IdType,
    marker: Optional[PageMarkerType] = Optional.Absent,
    limit: Optional[LimitType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest = {
    import DescribeNotificationSubscriptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest
      .builder()
      .organizationId(IdType.unwrap(organizationId): java.lang.String)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest.ReadOnly =
    zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest
      .wrap(buildAwsValue())
}
object DescribeNotificationSubscriptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest =
      zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest(
        organizationId,
        marker.map(value => value),
        limit.map(value => value)
      )
    def organizationId: IdType
    def marker: Optional[PageMarkerType]
    def limit: Optional[LimitType]
    def getOrganizationId: ZIO[Any, Nothing, IdType] =
      ZIO.succeed(organizationId)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest
  ) extends zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest.ReadOnly {
    override val organizationId: IdType =
      zio.aws.workdocs.model.primitives.IdType(impl.organizationId())
    override val marker: Optional[PageMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
    override val limit: Optional[LimitType] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest
  ): zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest.ReadOnly =
    new Wrapper(impl)
}
