package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{SubscriptionEndPointType, IdType}
import scala.jdk.CollectionConverters.*
final case class Subscription(
    subscriptionId: Optional[IdType] = Optional.Absent,
    endPoint: Optional[SubscriptionEndPointType] = Optional.Absent,
    protocol: Optional[zio.aws.workdocs.model.SubscriptionProtocolType] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.Subscription = {
    import Subscription.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.Subscription
      .builder()
      .optionallyWith(
        subscriptionId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.subscriptionId)
      .optionallyWith(
        endPoint.map(value =>
          SubscriptionEndPointType.unwrap(value): java.lang.String
        )
      )(_.endPoint)
      .optionallyWith(protocol.map(value => value.unwrap))(_.protocol)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.Subscription.ReadOnly =
    zio.aws.workdocs.model.Subscription.wrap(buildAwsValue())
}
object Subscription {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.Subscription
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.Subscription =
      zio.aws.workdocs.model.Subscription(
        subscriptionId.map(value => value),
        endPoint.map(value => value),
        protocol.map(value => value)
      )
    def subscriptionId: Optional[IdType]
    def endPoint: Optional[SubscriptionEndPointType]
    def protocol: Optional[zio.aws.workdocs.model.SubscriptionProtocolType]
    def getSubscriptionId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("subscriptionId", subscriptionId)
    def getEndPoint: ZIO[Any, AwsError, SubscriptionEndPointType] =
      AwsError.unwrapOptionField("endPoint", endPoint)
    def getProtocol
        : ZIO[Any, AwsError, zio.aws.workdocs.model.SubscriptionProtocolType] =
      AwsError.unwrapOptionField("protocol", protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.Subscription
  ) extends zio.aws.workdocs.model.Subscription.ReadOnly {
    override val subscriptionId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.subscriptionId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val endPoint: Optional[SubscriptionEndPointType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.endPoint())
        .map(value =>
          zio.aws.workdocs.model.primitives.SubscriptionEndPointType(value)
        )
    override val protocol
        : Optional[zio.aws.workdocs.model.SubscriptionProtocolType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.protocol())
        .map(value =>
          zio.aws.workdocs.model.SubscriptionProtocolType.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.Subscription
  ): zio.aws.workdocs.model.Subscription.ReadOnly = new Wrapper(impl)
}
