package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{GroupNameType, IdType}
import scala.jdk.CollectionConverters.*
final case class GroupMetadata(
    id: Optional[IdType] = Optional.Absent,
    name: Optional[GroupNameType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GroupMetadata = {
    import GroupMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GroupMetadata
      .builder()
      .optionallyWith(id.map(value => IdType.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        name.map(value => GroupNameType.unwrap(value): java.lang.String)
      )(_.name)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GroupMetadata.ReadOnly =
    zio.aws.workdocs.model.GroupMetadata.wrap(buildAwsValue())
}
object GroupMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GroupMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GroupMetadata =
      zio.aws.workdocs.model
        .GroupMetadata(id.map(value => value), name.map(value => value))
    def id: Optional[IdType]
    def name: Optional[GroupNameType]
    def getId: ZIO[Any, AwsError, IdType] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, GroupNameType] =
      AwsError.unwrapOptionField("name", name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GroupMetadata
  ) extends zio.aws.workdocs.model.GroupMetadata.ReadOnly {
    override val id: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val name: Optional[GroupNameType] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.workdocs.model.primitives.GroupNameType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GroupMetadata
  ): zio.aws.workdocs.model.GroupMetadata.ReadOnly = new Wrapper(impl)
}
