package zio.aws.workdocs.model
import scala.jdk.CollectionConverters.*
sealed trait DocumentVersionStatus {
  def unwrap
      : software.amazon.awssdk.services.workdocs.model.DocumentVersionStatus
}
object DocumentVersionStatus {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.DocumentVersionStatus
  ): zio.aws.workdocs.model.DocumentVersionStatus = value match {
    case software.amazon.awssdk.services.workdocs.model.DocumentVersionStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.DocumentVersionStatus.ACTIVE =>
      val r = ACTIVE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.DocumentVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.DocumentVersionStatus =
      software.amazon.awssdk.services.workdocs.model.DocumentVersionStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.workdocs.model.DocumentVersionStatus {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.DocumentVersionStatus =
      software.amazon.awssdk.services.workdocs.model.DocumentVersionStatus.ACTIVE
  }
}
