package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetCurrentUserResponse(
    user: Optional[zio.aws.workdocs.model.User] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GetCurrentUserResponse = {
    import GetCurrentUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GetCurrentUserResponse
      .builder()
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GetCurrentUserResponse.ReadOnly =
    zio.aws.workdocs.model.GetCurrentUserResponse.wrap(buildAwsValue())
}
object GetCurrentUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GetCurrentUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GetCurrentUserResponse =
      zio.aws.workdocs.model
        .GetCurrentUserResponse(user.map(value => value.asEditable))
    def user: Optional[zio.aws.workdocs.model.User.ReadOnly]
    def getUser: ZIO[Any, AwsError, zio.aws.workdocs.model.User.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GetCurrentUserResponse
  ) extends zio.aws.workdocs.model.GetCurrentUserResponse.ReadOnly {
    override val user: Optional[zio.aws.workdocs.model.User.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.user())
        .map(value => zio.aws.workdocs.model.User.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GetCurrentUserResponse
  ): zio.aws.workdocs.model.GetCurrentUserResponse.ReadOnly = new Wrapper(impl)
}
