package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{
  FieldNamesType,
  PageMarkerType,
  LimitType,
  AuthenticationHeaderType,
  ResourceIdType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeFolderContentsRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    folderId: ResourceIdType,
    sort: Optional[zio.aws.workdocs.model.ResourceSortType] = Optional.Absent,
    order: Optional[zio.aws.workdocs.model.OrderType] = Optional.Absent,
    limit: Optional[LimitType] = Optional.Absent,
    marker: Optional[PageMarkerType] = Optional.Absent,
    `type`: Optional[zio.aws.workdocs.model.FolderContentType] =
      Optional.Absent,
    include: Optional[FieldNamesType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest = {
    import DescribeFolderContentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .folderId(ResourceIdType.unwrap(folderId): java.lang.String)
      .optionallyWith(sort.map(value => value.unwrap))(_.sort)
      .optionallyWith(order.map(value => value.unwrap))(_.order)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        include.map(value => FieldNamesType.unwrap(value): java.lang.String)
      )(_.include)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.DescribeFolderContentsRequest.ReadOnly =
    zio.aws.workdocs.model.DescribeFolderContentsRequest.wrap(buildAwsValue())
}
object DescribeFolderContentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeFolderContentsRequest =
      zio.aws.workdocs.model.DescribeFolderContentsRequest(
        authenticationToken.map(value => value),
        folderId,
        sort.map(value => value),
        order.map(value => value),
        limit.map(value => value),
        marker.map(value => value),
        `type`.map(value => value),
        include.map(value => value)
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def folderId: ResourceIdType
    def sort: Optional[zio.aws.workdocs.model.ResourceSortType]
    def order: Optional[zio.aws.workdocs.model.OrderType]
    def limit: Optional[LimitType]
    def marker: Optional[PageMarkerType]
    def `type`: Optional[zio.aws.workdocs.model.FolderContentType]
    def include: Optional[FieldNamesType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getFolderId: ZIO[Any, Nothing, ResourceIdType] = ZIO.succeed(folderId)
    def getSort: ZIO[Any, AwsError, zio.aws.workdocs.model.ResourceSortType] =
      AwsError.unwrapOptionField("sort", sort)
    def getOrder: ZIO[Any, AwsError, zio.aws.workdocs.model.OrderType] =
      AwsError.unwrapOptionField("order", order)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getType: ZIO[Any, AwsError, zio.aws.workdocs.model.FolderContentType] =
      AwsError.unwrapOptionField("type", `type`)
    def getInclude: ZIO[Any, AwsError, FieldNamesType] =
      AwsError.unwrapOptionField("include", include)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest
  ) extends zio.aws.workdocs.model.DescribeFolderContentsRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val folderId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.folderId())
    override val sort: Optional[zio.aws.workdocs.model.ResourceSortType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sort())
        .map(value => zio.aws.workdocs.model.ResourceSortType.wrap(value))
    override val order: Optional[zio.aws.workdocs.model.OrderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.order())
        .map(value => zio.aws.workdocs.model.OrderType.wrap(value))
    override val limit: Optional[LimitType] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val marker: Optional[PageMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
    override val `type`: Optional[zio.aws.workdocs.model.FolderContentType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.workdocs.model.FolderContentType.wrap(value))
    override val include: Optional[FieldNamesType] = zio.aws.core.internal
      .optionalFromNullable(impl.include())
      .map(value => zio.aws.workdocs.model.primitives.FieldNamesType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsRequest
  ): zio.aws.workdocs.model.DescribeFolderContentsRequest.ReadOnly =
    new Wrapper(impl)
}
