package zio.aws.workdocs.model
import scala.jdk.CollectionConverters.*
sealed trait RoleType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.RoleType
}
object RoleType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.RoleType
  ): zio.aws.workdocs.model.RoleType = value match {
    case software.amazon.awssdk.services.workdocs.model.RoleType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.RoleType.VIEWER =>
      val r = VIEWER
      r
    case software.amazon.awssdk.services.workdocs.model.RoleType.CONTRIBUTOR =>
      val r = CONTRIBUTOR
      r
    case software.amazon.awssdk.services.workdocs.model.RoleType.OWNER =>
      val r = OWNER
      r
    case software.amazon.awssdk.services.workdocs.model.RoleType.COOWNER =>
      val r = COOWNER
      r
  }
  case object unknownToSdkVersion extends zio.aws.workdocs.model.RoleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.RoleType =
      software.amazon.awssdk.services.workdocs.model.RoleType.UNKNOWN_TO_SDK_VERSION
  }
  case object VIEWER extends zio.aws.workdocs.model.RoleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.RoleType =
      software.amazon.awssdk.services.workdocs.model.RoleType.VIEWER
  }
  case object CONTRIBUTOR extends zio.aws.workdocs.model.RoleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.RoleType =
      software.amazon.awssdk.services.workdocs.model.RoleType.CONTRIBUTOR
  }
  case object OWNER extends zio.aws.workdocs.model.RoleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.RoleType =
      software.amazon.awssdk.services.workdocs.model.RoleType.OWNER
  }
  case object COOWNER extends zio.aws.workdocs.model.RoleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.RoleType =
      software.amazon.awssdk.services.workdocs.model.RoleType.COOWNER
  }
}
