package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{IdType, BooleanType, TimestampType}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Activity(
    `type`: Optional[zio.aws.workdocs.model.ActivityType] = Optional.Absent,
    timeStamp: Optional[TimestampType] = Optional.Absent,
    isIndirectActivity: Optional[BooleanType] = Optional.Absent,
    organizationId: Optional[IdType] = Optional.Absent,
    initiator: Optional[zio.aws.workdocs.model.UserMetadata] = Optional.Absent,
    participants: Optional[zio.aws.workdocs.model.Participants] =
      Optional.Absent,
    resourceMetadata: Optional[zio.aws.workdocs.model.ResourceMetadata] =
      Optional.Absent,
    originalParent: Optional[zio.aws.workdocs.model.ResourceMetadata] =
      Optional.Absent,
    commentMetadata: Optional[zio.aws.workdocs.model.CommentMetadata] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.Activity = {
    import Activity.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.Activity
      .builder()
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        timeStamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.timeStamp)
      .optionallyWith(
        isIndirectActivity.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.isIndirectActivity)
      .optionallyWith(
        organizationId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.organizationId)
      .optionallyWith(initiator.map(value => value.buildAwsValue()))(
        _.initiator
      )
      .optionallyWith(participants.map(value => value.buildAwsValue()))(
        _.participants
      )
      .optionallyWith(resourceMetadata.map(value => value.buildAwsValue()))(
        _.resourceMetadata
      )
      .optionallyWith(originalParent.map(value => value.buildAwsValue()))(
        _.originalParent
      )
      .optionallyWith(commentMetadata.map(value => value.buildAwsValue()))(
        _.commentMetadata
      )
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.Activity.ReadOnly =
    zio.aws.workdocs.model.Activity.wrap(buildAwsValue())
}
object Activity {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.workdocs.model.Activity] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.Activity =
      zio.aws.workdocs.model.Activity(
        `type`.map(value => value),
        timeStamp.map(value => value),
        isIndirectActivity.map(value => value),
        organizationId.map(value => value),
        initiator.map(value => value.asEditable),
        participants.map(value => value.asEditable),
        resourceMetadata.map(value => value.asEditable),
        originalParent.map(value => value.asEditable),
        commentMetadata.map(value => value.asEditable)
      )
    def `type`: Optional[zio.aws.workdocs.model.ActivityType]
    def timeStamp: Optional[TimestampType]
    def isIndirectActivity: Optional[BooleanType]
    def organizationId: Optional[IdType]
    def initiator: Optional[zio.aws.workdocs.model.UserMetadata.ReadOnly]
    def participants: Optional[zio.aws.workdocs.model.Participants.ReadOnly]
    def resourceMetadata
        : Optional[zio.aws.workdocs.model.ResourceMetadata.ReadOnly]
    def originalParent
        : Optional[zio.aws.workdocs.model.ResourceMetadata.ReadOnly]
    def commentMetadata
        : Optional[zio.aws.workdocs.model.CommentMetadata.ReadOnly]
    def getType: ZIO[Any, AwsError, zio.aws.workdocs.model.ActivityType] =
      AwsError.unwrapOptionField("type", `type`)
    def getTimeStamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("timeStamp", timeStamp)
    def getIsIndirectActivity: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("isIndirectActivity", isIndirectActivity)
    def getOrganizationId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("organizationId", organizationId)
    def getInitiator
        : ZIO[Any, AwsError, zio.aws.workdocs.model.UserMetadata.ReadOnly] =
      AwsError.unwrapOptionField("initiator", initiator)
    def getParticipants
        : ZIO[Any, AwsError, zio.aws.workdocs.model.Participants.ReadOnly] =
      AwsError.unwrapOptionField("participants", participants)
    def getResourceMetadata
        : ZIO[Any, AwsError, zio.aws.workdocs.model.ResourceMetadata.ReadOnly] =
      AwsError.unwrapOptionField("resourceMetadata", resourceMetadata)
    def getOriginalParent
        : ZIO[Any, AwsError, zio.aws.workdocs.model.ResourceMetadata.ReadOnly] =
      AwsError.unwrapOptionField("originalParent", originalParent)
    def getCommentMetadata
        : ZIO[Any, AwsError, zio.aws.workdocs.model.CommentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("commentMetadata", commentMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.Activity
  ) extends zio.aws.workdocs.model.Activity.ReadOnly {
    override val `type`: Optional[zio.aws.workdocs.model.ActivityType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.workdocs.model.ActivityType.wrap(value))
    override val timeStamp: Optional[TimestampType] = zio.aws.core.internal
      .optionalFromNullable(impl.timeStamp())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val isIndirectActivity: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.isIndirectActivity())
        .map(value => zio.aws.workdocs.model.primitives.BooleanType(value))
    override val organizationId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val initiator
        : Optional[zio.aws.workdocs.model.UserMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.initiator())
        .map(value => zio.aws.workdocs.model.UserMetadata.wrap(value))
    override val participants
        : Optional[zio.aws.workdocs.model.Participants.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.participants())
        .map(value => zio.aws.workdocs.model.Participants.wrap(value))
    override val resourceMetadata
        : Optional[zio.aws.workdocs.model.ResourceMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceMetadata())
        .map(value => zio.aws.workdocs.model.ResourceMetadata.wrap(value))
    override val originalParent
        : Optional[zio.aws.workdocs.model.ResourceMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.originalParent())
        .map(value => zio.aws.workdocs.model.ResourceMetadata.wrap(value))
    override val commentMetadata
        : Optional[zio.aws.workdocs.model.CommentMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.commentMetadata())
        .map(value => zio.aws.workdocs.model.CommentMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.Activity
  ): zio.aws.workdocs.model.Activity.ReadOnly = new Wrapper(impl)
}
