package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{
  EmailAddressType,
  UserAttributeValueType,
  UsernameType,
  IdType
}
import scala.jdk.CollectionConverters.*
final case class UserMetadata(
    id: Optional[IdType] = Optional.Absent,
    username: Optional[UsernameType] = Optional.Absent,
    givenName: Optional[UserAttributeValueType] = Optional.Absent,
    surname: Optional[UserAttributeValueType] = Optional.Absent,
    emailAddress: Optional[EmailAddressType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.UserMetadata = {
    import UserMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.UserMetadata
      .builder()
      .optionallyWith(id.map(value => IdType.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        username.map(value => UsernameType.unwrap(value): java.lang.String)
      )(_.username)
      .optionallyWith(
        givenName.map(value =>
          UserAttributeValueType.unwrap(value): java.lang.String
        )
      )(_.givenName)
      .optionallyWith(
        surname.map(value =>
          UserAttributeValueType.unwrap(value): java.lang.String
        )
      )(_.surname)
      .optionallyWith(
        emailAddress.map(value =>
          EmailAddressType.unwrap(value): java.lang.String
        )
      )(_.emailAddress)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.UserMetadata.ReadOnly =
    zio.aws.workdocs.model.UserMetadata.wrap(buildAwsValue())
}
object UserMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.UserMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.UserMetadata =
      zio.aws.workdocs.model.UserMetadata(
        id.map(value => value),
        username.map(value => value),
        givenName.map(value => value),
        surname.map(value => value),
        emailAddress.map(value => value)
      )
    def id: Optional[IdType]
    def username: Optional[UsernameType]
    def givenName: Optional[UserAttributeValueType]
    def surname: Optional[UserAttributeValueType]
    def emailAddress: Optional[EmailAddressType]
    def getId: ZIO[Any, AwsError, IdType] = AwsError.unwrapOptionField("id", id)
    def getUsername: ZIO[Any, AwsError, UsernameType] =
      AwsError.unwrapOptionField("username", username)
    def getGivenName: ZIO[Any, AwsError, UserAttributeValueType] =
      AwsError.unwrapOptionField("givenName", givenName)
    def getSurname: ZIO[Any, AwsError, UserAttributeValueType] =
      AwsError.unwrapOptionField("surname", surname)
    def getEmailAddress: ZIO[Any, AwsError, EmailAddressType] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.UserMetadata
  ) extends zio.aws.workdocs.model.UserMetadata.ReadOnly {
    override val id: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val username: Optional[UsernameType] = zio.aws.core.internal
      .optionalFromNullable(impl.username())
      .map(value => zio.aws.workdocs.model.primitives.UsernameType(value))
    override val givenName: Optional[UserAttributeValueType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.givenName())
        .map(value =>
          zio.aws.workdocs.model.primitives.UserAttributeValueType(value)
        )
    override val surname: Optional[UserAttributeValueType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.surname())
        .map(value =>
          zio.aws.workdocs.model.primitives.UserAttributeValueType(value)
        )
    override val emailAddress: Optional[EmailAddressType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailAddress())
        .map(value => zio.aws.workdocs.model.primitives.EmailAddressType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.UserMetadata
  ): zio.aws.workdocs.model.UserMetadata.ReadOnly = new Wrapper(impl)
}
