package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{
  SharedLabel,
  TimestampType,
  IdType,
  ResourceIdType
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DocumentMetadata(
    id: Optional[ResourceIdType] = Optional.Absent,
    creatorId: Optional[IdType] = Optional.Absent,
    parentFolderId: Optional[ResourceIdType] = Optional.Absent,
    createdTimestamp: Optional[TimestampType] = Optional.Absent,
    modifiedTimestamp: Optional[TimestampType] = Optional.Absent,
    latestVersionMetadata: Optional[
      zio.aws.workdocs.model.DocumentVersionMetadata
    ] = Optional.Absent,
    resourceState: Optional[zio.aws.workdocs.model.ResourceStateType] =
      Optional.Absent,
    labels: Optional[Iterable[SharedLabel]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DocumentMetadata = {
    import DocumentMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DocumentMetadata
      .builder()
      .optionallyWith(
        id.map(value => ResourceIdType.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        creatorId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.creatorId)
      .optionallyWith(
        parentFolderId.map(value =>
          ResourceIdType.unwrap(value): java.lang.String
        )
      )(_.parentFolderId)
      .optionallyWith(
        createdTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        modifiedTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.modifiedTimestamp)
      .optionallyWith(
        latestVersionMetadata.map(value => value.buildAwsValue())
      )(_.latestVersionMetadata)
      .optionallyWith(resourceState.map(value => value.unwrap))(_.resourceState)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            SharedLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DocumentMetadata.ReadOnly =
    zio.aws.workdocs.model.DocumentMetadata.wrap(buildAwsValue())
}
object DocumentMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DocumentMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DocumentMetadata =
      zio.aws.workdocs.model.DocumentMetadata(
        id.map(value => value),
        creatorId.map(value => value),
        parentFolderId.map(value => value),
        createdTimestamp.map(value => value),
        modifiedTimestamp.map(value => value),
        latestVersionMetadata.map(value => value.asEditable),
        resourceState.map(value => value),
        labels.map(value => value)
      )
    def id: Optional[ResourceIdType]
    def creatorId: Optional[IdType]
    def parentFolderId: Optional[ResourceIdType]
    def createdTimestamp: Optional[TimestampType]
    def modifiedTimestamp: Optional[TimestampType]
    def latestVersionMetadata
        : Optional[zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly]
    def resourceState: Optional[zio.aws.workdocs.model.ResourceStateType]
    def labels: Optional[List[SharedLabel]]
    def getId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("id", id)
    def getCreatorId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("creatorId", creatorId)
    def getParentFolderId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("parentFolderId", parentFolderId)
    def getCreatedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getModifiedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("modifiedTimestamp", modifiedTimestamp)
    def getLatestVersionMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly
    ] =
      AwsError.unwrapOptionField("latestVersionMetadata", latestVersionMetadata)
    def getResourceState
        : ZIO[Any, AwsError, zio.aws.workdocs.model.ResourceStateType] =
      AwsError.unwrapOptionField("resourceState", resourceState)
    def getLabels: ZIO[Any, AwsError, List[SharedLabel]] =
      AwsError.unwrapOptionField("labels", labels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DocumentMetadata
  ) extends zio.aws.workdocs.model.DocumentMetadata.ReadOnly {
    override val id: Optional[ResourceIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val creatorId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.creatorId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val parentFolderId: Optional[ResourceIdType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parentFolderId())
        .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val createdTimestamp: Optional[TimestampType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createdTimestamp())
        .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val modifiedTimestamp: Optional[TimestampType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.modifiedTimestamp())
        .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val latestVersionMetadata
        : Optional[zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.latestVersionMetadata())
        .map(value =>
          zio.aws.workdocs.model.DocumentVersionMetadata.wrap(value)
        )
    override val resourceState
        : Optional[zio.aws.workdocs.model.ResourceStateType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceState())
        .map(value => zio.aws.workdocs.model.ResourceStateType.wrap(value))
    override val labels: Optional[List[SharedLabel]] = zio.aws.core.internal
      .optionalFromNullable(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workdocs.model.primitives.SharedLabel(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DocumentMetadata
  ): zio.aws.workdocs.model.DocumentMetadata.ReadOnly = new Wrapper(impl)
}
