package zio.aws.workdocs.model
import scala.jdk.CollectionConverters.*
sealed trait CommentVisibilityType {
  def unwrap
      : software.amazon.awssdk.services.workdocs.model.CommentVisibilityType
}
object CommentVisibilityType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.CommentVisibilityType
  ): zio.aws.workdocs.model.CommentVisibilityType = value match {
    case software.amazon.awssdk.services.workdocs.model.CommentVisibilityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.CommentVisibilityType.PUBLIC =>
      val r = PUBLIC
      r
    case software.amazon.awssdk.services.workdocs.model.CommentVisibilityType.PRIVATE =>
      val r = PRIVATE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.CommentVisibilityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.CommentVisibilityType =
      software.amazon.awssdk.services.workdocs.model.CommentVisibilityType.UNKNOWN_TO_SDK_VERSION
  }
  case object PUBLIC extends zio.aws.workdocs.model.CommentVisibilityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.CommentVisibilityType =
      software.amazon.awssdk.services.workdocs.model.CommentVisibilityType.PUBLIC
  }
  case object PRIVATE extends zio.aws.workdocs.model.CommentVisibilityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.CommentVisibilityType =
      software.amazon.awssdk.services.workdocs.model.CommentVisibilityType.PRIVATE
  }
}
