package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{
  SearchQueryType,
  IdType,
  UserIdsType,
  FieldNamesType,
  PageMarkerType,
  LimitType,
  AuthenticationHeaderType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeUsersRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    organizationId: Optional[IdType] = Optional.Absent,
    userIds: Optional[UserIdsType] = Optional.Absent,
    query: Optional[SearchQueryType] = Optional.Absent,
    include: Optional[zio.aws.workdocs.model.UserFilterType] = Optional.Absent,
    order: Optional[zio.aws.workdocs.model.OrderType] = Optional.Absent,
    sort: Optional[zio.aws.workdocs.model.UserSortType] = Optional.Absent,
    marker: Optional[PageMarkerType] = Optional.Absent,
    limit: Optional[LimitType] = Optional.Absent,
    fields: Optional[FieldNamesType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest = {
    import DescribeUsersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .optionallyWith(
        organizationId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.organizationId)
      .optionallyWith(
        userIds.map(value => UserIdsType.unwrap(value): java.lang.String)
      )(_.userIds)
      .optionallyWith(
        query.map(value => SearchQueryType.unwrap(value): java.lang.String)
      )(_.query)
      .optionallyWith(include.map(value => value.unwrap))(_.include)
      .optionallyWith(order.map(value => value.unwrap))(_.order)
      .optionallyWith(sort.map(value => value.unwrap))(_.sort)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        fields.map(value => FieldNamesType.unwrap(value): java.lang.String)
      )(_.fields)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DescribeUsersRequest.ReadOnly =
    zio.aws.workdocs.model.DescribeUsersRequest.wrap(buildAwsValue())
}
object DescribeUsersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeUsersRequest =
      zio.aws.workdocs.model.DescribeUsersRequest(
        authenticationToken.map(value => value),
        organizationId.map(value => value),
        userIds.map(value => value),
        query.map(value => value),
        include.map(value => value),
        order.map(value => value),
        sort.map(value => value),
        marker.map(value => value),
        limit.map(value => value),
        fields.map(value => value)
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def organizationId: Optional[IdType]
    def userIds: Optional[UserIdsType]
    def query: Optional[SearchQueryType]
    def include: Optional[zio.aws.workdocs.model.UserFilterType]
    def order: Optional[zio.aws.workdocs.model.OrderType]
    def sort: Optional[zio.aws.workdocs.model.UserSortType]
    def marker: Optional[PageMarkerType]
    def limit: Optional[LimitType]
    def fields: Optional[FieldNamesType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getOrganizationId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("organizationId", organizationId)
    def getUserIds: ZIO[Any, AwsError, UserIdsType] =
      AwsError.unwrapOptionField("userIds", userIds)
    def getQuery: ZIO[Any, AwsError, SearchQueryType] =
      AwsError.unwrapOptionField("query", query)
    def getInclude: ZIO[Any, AwsError, zio.aws.workdocs.model.UserFilterType] =
      AwsError.unwrapOptionField("include", include)
    def getOrder: ZIO[Any, AwsError, zio.aws.workdocs.model.OrderType] =
      AwsError.unwrapOptionField("order", order)
    def getSort: ZIO[Any, AwsError, zio.aws.workdocs.model.UserSortType] =
      AwsError.unwrapOptionField("sort", sort)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getFields: ZIO[Any, AwsError, FieldNamesType] =
      AwsError.unwrapOptionField("fields", fields)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest
  ) extends zio.aws.workdocs.model.DescribeUsersRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val organizationId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.organizationId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val userIds: Optional[UserIdsType] = zio.aws.core.internal
      .optionalFromNullable(impl.userIds())
      .map(value => zio.aws.workdocs.model.primitives.UserIdsType(value))
    override val query: Optional[SearchQueryType] = zio.aws.core.internal
      .optionalFromNullable(impl.query())
      .map(value => zio.aws.workdocs.model.primitives.SearchQueryType(value))
    override val include: Optional[zio.aws.workdocs.model.UserFilterType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.include())
        .map(value => zio.aws.workdocs.model.UserFilterType.wrap(value))
    override val order: Optional[zio.aws.workdocs.model.OrderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.order())
        .map(value => zio.aws.workdocs.model.OrderType.wrap(value))
    override val sort: Optional[zio.aws.workdocs.model.UserSortType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sort())
        .map(value => zio.aws.workdocs.model.UserSortType.wrap(value))
    override val marker: Optional[PageMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
    override val limit: Optional[LimitType] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val fields: Optional[FieldNamesType] = zio.aws.core.internal
      .optionalFromNullable(impl.fields())
      .map(value => zio.aws.workdocs.model.primitives.FieldNamesType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeUsersRequest
  ): zio.aws.workdocs.model.DescribeUsersRequest.ReadOnly = new Wrapper(impl)
}
