package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateUserResponse(
    user: Optional[zio.aws.workdocs.model.User] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.UpdateUserResponse = {
    import UpdateUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.UpdateUserResponse
      .builder()
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.UpdateUserResponse.ReadOnly =
    zio.aws.workdocs.model.UpdateUserResponse.wrap(buildAwsValue())
}
object UpdateUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.UpdateUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.UpdateUserResponse =
      zio.aws.workdocs.model
        .UpdateUserResponse(user.map(value => value.asEditable))
    def user: Optional[zio.aws.workdocs.model.User.ReadOnly]
    def getUser: ZIO[Any, AwsError, zio.aws.workdocs.model.User.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.UpdateUserResponse
  ) extends zio.aws.workdocs.model.UpdateUserResponse.ReadOnly {
    override val user: Optional[zio.aws.workdocs.model.User.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.user())
        .map(value => zio.aws.workdocs.model.User.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.UpdateUserResponse
  ): zio.aws.workdocs.model.UpdateUserResponse.ReadOnly = new Wrapper(impl)
}
