package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.PageMarkerType
import scala.jdk.CollectionConverters.*
final case class DescribeFolderContentsResponse(
    folders: Optional[Iterable[zio.aws.workdocs.model.FolderMetadata]] =
      Optional.Absent,
    documents: Optional[Iterable[zio.aws.workdocs.model.DocumentMetadata]] =
      Optional.Absent,
    marker: Optional[PageMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse = {
    import DescribeFolderContentsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse
      .builder()
      .optionallyWith(
        folders.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.folders)
      .optionallyWith(
        documents.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documents)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.DescribeFolderContentsResponse.ReadOnly =
    zio.aws.workdocs.model.DescribeFolderContentsResponse.wrap(buildAwsValue())
}
object DescribeFolderContentsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeFolderContentsResponse =
      zio.aws.workdocs.model.DescribeFolderContentsResponse(
        folders.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        documents.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def folders: Optional[List[zio.aws.workdocs.model.FolderMetadata.ReadOnly]]
    def documents
        : Optional[List[zio.aws.workdocs.model.DocumentMetadata.ReadOnly]]
    def marker: Optional[PageMarkerType]
    def getFolders: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.FolderMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("folders", folders)
    def getDocuments: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.DocumentMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("documents", documents)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse
  ) extends zio.aws.workdocs.model.DescribeFolderContentsResponse.ReadOnly {
    override val folders
        : Optional[List[zio.aws.workdocs.model.FolderMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.folders())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.FolderMetadata.wrap(item)
          }.toList
        )
    override val documents
        : Optional[List[zio.aws.workdocs.model.DocumentMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.documents())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.workdocs.model.DocumentMetadata.wrap(item)
          }.toList
        )
    override val marker: Optional[PageMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeFolderContentsResponse
  ): zio.aws.workdocs.model.DescribeFolderContentsResponse.ReadOnly =
    new Wrapper(impl)
}
