package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateCommentResponse(
    comment: Optional[zio.aws.workdocs.model.Comment] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.CreateCommentResponse = {
    import CreateCommentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.CreateCommentResponse
      .builder()
      .optionallyWith(comment.map(value => value.buildAwsValue()))(_.comment)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.CreateCommentResponse.ReadOnly =
    zio.aws.workdocs.model.CreateCommentResponse.wrap(buildAwsValue())
}
object CreateCommentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.CreateCommentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.CreateCommentResponse =
      zio.aws.workdocs.model
        .CreateCommentResponse(comment.map(value => value.asEditable))
    def comment: Optional[zio.aws.workdocs.model.Comment.ReadOnly]
    def getComment
        : ZIO[Any, AwsError, zio.aws.workdocs.model.Comment.ReadOnly] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.CreateCommentResponse
  ) extends zio.aws.workdocs.model.CreateCommentResponse.ReadOnly {
    override val comment: Optional[zio.aws.workdocs.model.Comment.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.comment())
        .map(value => zio.aws.workdocs.model.Comment.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.CreateCommentResponse
  ): zio.aws.workdocs.model.CreateCommentResponse.ReadOnly = new Wrapper(impl)
}
