package zio.aws.workdocs.model
import scala.jdk.CollectionConverters.*
sealed trait UserType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.UserType
}
object UserType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.UserType
  ): zio.aws.workdocs.model.UserType = value match {
    case software.amazon.awssdk.services.workdocs.model.UserType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.UserType.USER =>
      val r = USER
      r
    case software.amazon.awssdk.services.workdocs.model.UserType.ADMIN =>
      val r = ADMIN
      r
    case software.amazon.awssdk.services.workdocs.model.UserType.POWERUSER =>
      val r = POWERUSER
      r
    case software.amazon.awssdk.services.workdocs.model.UserType.MINIMALUSER =>
      val r = MINIMALUSER
      r
    case software.amazon.awssdk.services.workdocs.model.UserType.WORKSPACESUSER =>
      val r = WORKSPACESUSER
      r
  }
  case object unknownToSdkVersion extends zio.aws.workdocs.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.UserType =
      software.amazon.awssdk.services.workdocs.model.UserType.UNKNOWN_TO_SDK_VERSION
  }
  case object USER extends zio.aws.workdocs.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.UserType =
      software.amazon.awssdk.services.workdocs.model.UserType.USER
  }
  case object ADMIN extends zio.aws.workdocs.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.UserType =
      software.amazon.awssdk.services.workdocs.model.UserType.ADMIN
  }
  case object POWERUSER extends zio.aws.workdocs.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.UserType =
      software.amazon.awssdk.services.workdocs.model.UserType.POWERUSER
  }
  case object MINIMALUSER extends zio.aws.workdocs.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.UserType =
      software.amazon.awssdk.services.workdocs.model.UserType.MINIMALUSER
  }
  case object WORKSPACESUSER extends zio.aws.workdocs.model.UserType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.UserType =
      software.amazon.awssdk.services.workdocs.model.UserType.WORKSPACESUSER
  }
}
