package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{
  ResourceIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class AddResourcePermissionsRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    resourceId: ResourceIdType,
    principals: Iterable[zio.aws.workdocs.model.SharePrincipal],
    notificationOptions: Optional[zio.aws.workdocs.model.NotificationOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsRequest = {
    import AddResourcePermissionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .resourceId(ResourceIdType.unwrap(resourceId): java.lang.String)
      .principals(principals.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(notificationOptions.map(value => value.buildAwsValue()))(
        _.notificationOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.AddResourcePermissionsRequest.ReadOnly =
    zio.aws.workdocs.model.AddResourcePermissionsRequest.wrap(buildAwsValue())
}
object AddResourcePermissionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.AddResourcePermissionsRequest =
      zio.aws.workdocs.model.AddResourcePermissionsRequest(
        authenticationToken.map(value => value),
        resourceId,
        principals.map { item =>
          item.asEditable
        },
        notificationOptions.map(value => value.asEditable)
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def resourceId: ResourceIdType
    def principals: List[zio.aws.workdocs.model.SharePrincipal.ReadOnly]
    def notificationOptions
        : Optional[zio.aws.workdocs.model.NotificationOptions.ReadOnly]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getResourceId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(resourceId)
    def getPrincipals: ZIO[Any, Nothing, List[
      zio.aws.workdocs.model.SharePrincipal.ReadOnly
    ]] = ZIO.succeed(principals)
    def getNotificationOptions: ZIO[
      Any,
      AwsError,
      zio.aws.workdocs.model.NotificationOptions.ReadOnly
    ] = AwsError.unwrapOptionField("notificationOptions", notificationOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsRequest
  ) extends zio.aws.workdocs.model.AddResourcePermissionsRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val resourceId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.resourceId())
    override val principals
        : List[zio.aws.workdocs.model.SharePrincipal.ReadOnly] = impl
      .principals()
      .asScala
      .map { item =>
        zio.aws.workdocs.model.SharePrincipal.wrap(item)
      }
      .toList
    override val notificationOptions
        : Optional[zio.aws.workdocs.model.NotificationOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationOptions())
        .map(value => zio.aws.workdocs.model.NotificationOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.AddResourcePermissionsRequest
  ): zio.aws.workdocs.model.AddResourcePermissionsRequest.ReadOnly =
    new Wrapper(impl)
}
