package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateUserResponse(
    user: Optional[zio.aws.workdocs.model.User] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.CreateUserResponse = {
    import CreateUserResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.CreateUserResponse
      .builder()
      .optionallyWith(user.map(value => value.buildAwsValue()))(_.user)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.CreateUserResponse.ReadOnly =
    zio.aws.workdocs.model.CreateUserResponse.wrap(buildAwsValue())
}
object CreateUserResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.CreateUserResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.CreateUserResponse =
      zio.aws.workdocs.model
        .CreateUserResponse(user.map(value => value.asEditable))
    def user: Optional[zio.aws.workdocs.model.User.ReadOnly]
    def getUser: ZIO[Any, AwsError, zio.aws.workdocs.model.User.ReadOnly] =
      AwsError.unwrapOptionField("user", user)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.CreateUserResponse
  ) extends zio.aws.workdocs.model.CreateUserResponse.ReadOnly {
    override val user: Optional[zio.aws.workdocs.model.User.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.user())
        .map(value => zio.aws.workdocs.model.User.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.CreateUserResponse
  ): zio.aws.workdocs.model.CreateUserResponse.ReadOnly = new Wrapper(impl)
}
