package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{MessageType, ResourceIdType, IdType}
import scala.jdk.CollectionConverters.*
final case class ShareResult(
    principalId: Optional[IdType] = Optional.Absent,
    inviteePrincipalId: Optional[IdType] = Optional.Absent,
    role: Optional[zio.aws.workdocs.model.RoleType] = Optional.Absent,
    status: Optional[zio.aws.workdocs.model.ShareStatusType] = Optional.Absent,
    shareId: Optional[ResourceIdType] = Optional.Absent,
    statusMessage: Optional[MessageType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.ShareResult = {
    import ShareResult.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.ShareResult
      .builder()
      .optionallyWith(
        principalId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.principalId)
      .optionallyWith(
        inviteePrincipalId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.inviteePrincipalId)
      .optionallyWith(role.map(value => value.unwrap))(_.role)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        shareId.map(value => ResourceIdType.unwrap(value): java.lang.String)
      )(_.shareId)
      .optionallyWith(
        statusMessage.map(value => MessageType.unwrap(value): java.lang.String)
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.ShareResult.ReadOnly =
    zio.aws.workdocs.model.ShareResult.wrap(buildAwsValue())
}
object ShareResult {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.ShareResult
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.ShareResult =
      zio.aws.workdocs.model.ShareResult(
        principalId.map(value => value),
        inviteePrincipalId.map(value => value),
        role.map(value => value),
        status.map(value => value),
        shareId.map(value => value),
        statusMessage.map(value => value)
      )
    def principalId: Optional[IdType]
    def inviteePrincipalId: Optional[IdType]
    def role: Optional[zio.aws.workdocs.model.RoleType]
    def status: Optional[zio.aws.workdocs.model.ShareStatusType]
    def shareId: Optional[ResourceIdType]
    def statusMessage: Optional[MessageType]
    def getPrincipalId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("principalId", principalId)
    def getInviteePrincipalId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("inviteePrincipalId", inviteePrincipalId)
    def getRole: ZIO[Any, AwsError, zio.aws.workdocs.model.RoleType] =
      AwsError.unwrapOptionField("role", role)
    def getStatus: ZIO[Any, AwsError, zio.aws.workdocs.model.ShareStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getShareId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("shareId", shareId)
    def getStatusMessage: ZIO[Any, AwsError, MessageType] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.ShareResult
  ) extends zio.aws.workdocs.model.ShareResult.ReadOnly {
    override val principalId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.principalId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val inviteePrincipalId: Optional[IdType] = zio.aws.core.internal
      .optionalFromNullable(impl.inviteePrincipalId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val role: Optional[zio.aws.workdocs.model.RoleType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.role())
        .map(value => zio.aws.workdocs.model.RoleType.wrap(value))
    override val status: Optional[zio.aws.workdocs.model.ShareStatusType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.workdocs.model.ShareStatusType.wrap(value))
    override val shareId: Optional[ResourceIdType] = zio.aws.core.internal
      .optionalFromNullable(impl.shareId())
      .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val statusMessage: Optional[MessageType] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.workdocs.model.primitives.MessageType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.ShareResult
  ): zio.aws.workdocs.model.ShareResult.ReadOnly = new Wrapper(impl)
}
