package zio.aws.workdocs.model
import scala.jdk.CollectionConverters.*
sealed trait ActivityType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.ActivityType
}
object ActivityType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.ActivityType
  ): zio.aws.workdocs.model.ActivityType = value match {
    case software.amazon.awssdk.services.workdocs.model.ActivityType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_CHECKED_IN =>
      val r = DOCUMENT_CHECKED_IN
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_CHECKED_OUT =>
      val r = DOCUMENT_CHECKED_OUT
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_RENAMED =>
      val r = DOCUMENT_RENAMED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_VERSION_UPLOADED =>
      val r = DOCUMENT_VERSION_UPLOADED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_VERSION_DELETED =>
      val r = DOCUMENT_VERSION_DELETED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_VERSION_VIEWED =>
      val r = DOCUMENT_VERSION_VIEWED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_VERSION_DOWNLOADED =>
      val r = DOCUMENT_VERSION_DOWNLOADED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_RECYCLED =>
      val r = DOCUMENT_RECYCLED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_RESTORED =>
      val r = DOCUMENT_RESTORED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_REVERTED =>
      val r = DOCUMENT_REVERTED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_SHARED =>
      val r = DOCUMENT_SHARED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_UNSHARED =>
      val r = DOCUMENT_UNSHARED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_SHARE_PERMISSION_CHANGED =>
      val r = DOCUMENT_SHARE_PERMISSION_CHANGED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_SHAREABLE_LINK_CREATED =>
      val r = DOCUMENT_SHAREABLE_LINK_CREATED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_SHAREABLE_LINK_REMOVED =>
      val r = DOCUMENT_SHAREABLE_LINK_REMOVED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_SHAREABLE_LINK_PERMISSION_CHANGED =>
      val r = DOCUMENT_SHAREABLE_LINK_PERMISSION_CHANGED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_MOVED =>
      val r = DOCUMENT_MOVED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_COMMENT_ADDED =>
      val r = DOCUMENT_COMMENT_ADDED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_COMMENT_DELETED =>
      val r = DOCUMENT_COMMENT_DELETED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_ANNOTATION_ADDED =>
      val r = DOCUMENT_ANNOTATION_ADDED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_ANNOTATION_DELETED =>
      val r = DOCUMENT_ANNOTATION_DELETED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_CREATED =>
      val r = FOLDER_CREATED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_DELETED =>
      val r = FOLDER_DELETED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_RENAMED =>
      val r = FOLDER_RENAMED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_RECYCLED =>
      val r = FOLDER_RECYCLED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_RESTORED =>
      val r = FOLDER_RESTORED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_SHARED =>
      val r = FOLDER_SHARED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_UNSHARED =>
      val r = FOLDER_UNSHARED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_SHARE_PERMISSION_CHANGED =>
      val r = FOLDER_SHARE_PERMISSION_CHANGED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_SHAREABLE_LINK_CREATED =>
      val r = FOLDER_SHAREABLE_LINK_CREATED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_SHAREABLE_LINK_REMOVED =>
      val r = FOLDER_SHAREABLE_LINK_REMOVED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_SHAREABLE_LINK_PERMISSION_CHANGED =>
      val r = FOLDER_SHAREABLE_LINK_PERMISSION_CHANGED
      r
    case software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_MOVED =>
      val r = FOLDER_MOVED
      r
  }
  case object unknownToSdkVersion extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.UNKNOWN_TO_SDK_VERSION
  }
  case object DOCUMENT_CHECKED_IN extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_CHECKED_IN
  }
  case object DOCUMENT_CHECKED_OUT extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_CHECKED_OUT
  }
  case object DOCUMENT_RENAMED extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_RENAMED
  }
  case object DOCUMENT_VERSION_UPLOADED
      extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_VERSION_UPLOADED
  }
  case object DOCUMENT_VERSION_DELETED
      extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_VERSION_DELETED
  }
  case object DOCUMENT_VERSION_VIEWED
      extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_VERSION_VIEWED
  }
  case object DOCUMENT_VERSION_DOWNLOADED
      extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_VERSION_DOWNLOADED
  }
  case object DOCUMENT_RECYCLED extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_RECYCLED
  }
  case object DOCUMENT_RESTORED extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_RESTORED
  }
  case object DOCUMENT_REVERTED extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_REVERTED
  }
  case object DOCUMENT_SHARED extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_SHARED
  }
  case object DOCUMENT_UNSHARED extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_UNSHARED
  }
  case object DOCUMENT_SHARE_PERMISSION_CHANGED
      extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_SHARE_PERMISSION_CHANGED
  }
  case object DOCUMENT_SHAREABLE_LINK_CREATED
      extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_SHAREABLE_LINK_CREATED
  }
  case object DOCUMENT_SHAREABLE_LINK_REMOVED
      extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_SHAREABLE_LINK_REMOVED
  }
  case object DOCUMENT_SHAREABLE_LINK_PERMISSION_CHANGED
      extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_SHAREABLE_LINK_PERMISSION_CHANGED
  }
  case object DOCUMENT_MOVED extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_MOVED
  }
  case object DOCUMENT_COMMENT_ADDED
      extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_COMMENT_ADDED
  }
  case object DOCUMENT_COMMENT_DELETED
      extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_COMMENT_DELETED
  }
  case object DOCUMENT_ANNOTATION_ADDED
      extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_ANNOTATION_ADDED
  }
  case object DOCUMENT_ANNOTATION_DELETED
      extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.DOCUMENT_ANNOTATION_DELETED
  }
  case object FOLDER_CREATED extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_CREATED
  }
  case object FOLDER_DELETED extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_DELETED
  }
  case object FOLDER_RENAMED extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_RENAMED
  }
  case object FOLDER_RECYCLED extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_RECYCLED
  }
  case object FOLDER_RESTORED extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_RESTORED
  }
  case object FOLDER_SHARED extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_SHARED
  }
  case object FOLDER_UNSHARED extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_UNSHARED
  }
  case object FOLDER_SHARE_PERMISSION_CHANGED
      extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_SHARE_PERMISSION_CHANGED
  }
  case object FOLDER_SHAREABLE_LINK_CREATED
      extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_SHAREABLE_LINK_CREATED
  }
  case object FOLDER_SHAREABLE_LINK_REMOVED
      extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_SHAREABLE_LINK_REMOVED
  }
  case object FOLDER_SHAREABLE_LINK_PERMISSION_CHANGED
      extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_SHAREABLE_LINK_PERMISSION_CHANGED
  }
  case object FOLDER_MOVED extends zio.aws.workdocs.model.ActivityType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ActivityType =
      software.amazon.awssdk.services.workdocs.model.ActivityType.FOLDER_MOVED
  }
}
