package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{
  ResourceIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class DeleteDocumentRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    documentId: ResourceIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DeleteDocumentRequest = {
    import DeleteDocumentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DeleteDocumentRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .documentId(ResourceIdType.unwrap(documentId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DeleteDocumentRequest.ReadOnly =
    zio.aws.workdocs.model.DeleteDocumentRequest.wrap(buildAwsValue())
}
object DeleteDocumentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DeleteDocumentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DeleteDocumentRequest =
      zio.aws.workdocs.model.DeleteDocumentRequest(
        authenticationToken.map(value => value),
        documentId
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def documentId: ResourceIdType
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getDocumentId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(documentId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteDocumentRequest
  ) extends zio.aws.workdocs.model.DeleteDocumentRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val documentId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.documentId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteDocumentRequest
  ): zio.aws.workdocs.model.DeleteDocumentRequest.ReadOnly = new Wrapper(impl)
}
