package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.workdocs.model.primitives.{
  BooleanType,
  FieldNamesType,
  DocumentVersionIdType,
  AuthenticationHeaderType,
  ResourceIdType
}
import scala.jdk.CollectionConverters.*
final case class GetDocumentVersionRequest(
    authenticationToken: Optional[AuthenticationHeaderType] = Optional.Absent,
    documentId: ResourceIdType,
    versionId: DocumentVersionIdType,
    fields: Optional[FieldNamesType] = Optional.Absent,
    includeCustomMetadata: Optional[BooleanType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest = {
    import GetDocumentVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .documentId(ResourceIdType.unwrap(documentId): java.lang.String)
      .versionId(DocumentVersionIdType.unwrap(versionId): java.lang.String)
      .optionallyWith(
        fields.map(value => FieldNamesType.unwrap(value): java.lang.String)
      )(_.fields)
      .optionallyWith(
        includeCustomMetadata.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.includeCustomMetadata)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GetDocumentVersionRequest.ReadOnly =
    zio.aws.workdocs.model.GetDocumentVersionRequest.wrap(buildAwsValue())
}
object GetDocumentVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GetDocumentVersionRequest =
      zio.aws.workdocs.model.GetDocumentVersionRequest(
        authenticationToken.map(value => value),
        documentId,
        versionId,
        fields.map(value => value),
        includeCustomMetadata.map(value => value)
      )
    def authenticationToken: Optional[AuthenticationHeaderType]
    def documentId: ResourceIdType
    def versionId: DocumentVersionIdType
    def fields: Optional[FieldNamesType]
    def includeCustomMetadata: Optional[BooleanType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getDocumentId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(documentId)
    def getVersionId: ZIO[Any, Nothing, DocumentVersionIdType] =
      ZIO.succeed(versionId)
    def getFields: ZIO[Any, AwsError, FieldNamesType] =
      AwsError.unwrapOptionField("fields", fields)
    def getIncludeCustomMetadata: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("includeCustomMetadata", includeCustomMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest
  ) extends zio.aws.workdocs.model.GetDocumentVersionRequest.ReadOnly {
    override val authenticationToken: Optional[AuthenticationHeaderType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.authenticationToken())
        .map(value =>
          zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
        )
    override val documentId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.documentId())
    override val versionId: DocumentVersionIdType =
      zio.aws.workdocs.model.primitives.DocumentVersionIdType(impl.versionId())
    override val fields: Optional[FieldNamesType] = zio.aws.core.internal
      .optionalFromNullable(impl.fields())
      .map(value => zio.aws.workdocs.model.primitives.FieldNamesType(value))
    override val includeCustomMetadata: Optional[BooleanType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeCustomMetadata())
        .map(value => zio.aws.workdocs.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GetDocumentVersionRequest
  ): zio.aws.workdocs.model.GetDocumentVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
