package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{
  PageMarkerType,
  LimitType,
  AuthenticationHeaderType
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeRootFoldersRequest(
    authenticationToken: AuthenticationHeaderType,
    limit: Optional[LimitType] = Optional.Absent,
    marker: Optional[PageMarkerType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest = {
    import DescribeRootFoldersRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest
      .builder()
      .authenticationToken(
        AuthenticationHeaderType.unwrap(authenticationToken): java.lang.String
      )
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DescribeRootFoldersRequest.ReadOnly =
    zio.aws.workdocs.model.DescribeRootFoldersRequest.wrap(buildAwsValue())
}
object DescribeRootFoldersRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeRootFoldersRequest =
      zio.aws.workdocs.model.DescribeRootFoldersRequest(
        authenticationToken,
        limit.map(value => value),
        marker.map(value => value)
      )
    def authenticationToken: AuthenticationHeaderType
    def limit: Optional[LimitType]
    def marker: Optional[PageMarkerType]
    def getAuthenticationToken: ZIO[Any, Nothing, AuthenticationHeaderType] =
      ZIO.succeed(authenticationToken)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest
  ) extends zio.aws.workdocs.model.DescribeRootFoldersRequest.ReadOnly {
    override val authenticationToken: AuthenticationHeaderType =
      zio.aws.workdocs.model.primitives
        .AuthenticationHeaderType(impl.authenticationToken())
    override val limit: Optional[LimitType] = zio.aws.core.internal
      .optionalFromNullable(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val marker: Optional[PageMarkerType] = zio.aws.core.internal
      .optionalFromNullable(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeRootFoldersRequest
  ): zio.aws.workdocs.model.DescribeRootFoldersRequest.ReadOnly = new Wrapper(
    impl
  )
}
