package zio.aws.workdocs.model
import scala.jdk.CollectionConverters.*
sealed trait ShareStatusType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.ShareStatusType
}
object ShareStatusType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.ShareStatusType
  ): zio.aws.workdocs.model.ShareStatusType = value match {
    case software.amazon.awssdk.services.workdocs.model.ShareStatusType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.ShareStatusType.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.workdocs.model.ShareStatusType.FAILURE =>
      val r = FAILURE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.ShareStatusType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ShareStatusType =
      software.amazon.awssdk.services.workdocs.model.ShareStatusType.UNKNOWN_TO_SDK_VERSION
  }
  case object SUCCESS extends zio.aws.workdocs.model.ShareStatusType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ShareStatusType =
      software.amazon.awssdk.services.workdocs.model.ShareStatusType.SUCCESS
  }
  case object FAILURE extends zio.aws.workdocs.model.ShareStatusType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ShareStatusType =
      software.amazon.awssdk.services.workdocs.model.ShareStatusType.FAILURE
  }
}
