package zio.aws.workdocs.model
import scala.jdk.CollectionConverters.*
sealed trait LocaleType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.LocaleType
}
object LocaleType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.LocaleType
  ): zio.aws.workdocs.model.LocaleType = value match {
    case software.amazon.awssdk.services.workdocs.model.LocaleType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.LocaleType.EN =>
      val r = en
      r
    case software.amazon.awssdk.services.workdocs.model.LocaleType.FR =>
      val r = fr
      r
    case software.amazon.awssdk.services.workdocs.model.LocaleType.KO =>
      val r = ko
      r
    case software.amazon.awssdk.services.workdocs.model.LocaleType.DE =>
      val r = de
      r
    case software.amazon.awssdk.services.workdocs.model.LocaleType.ES =>
      val r = es
      r
    case software.amazon.awssdk.services.workdocs.model.LocaleType.JA =>
      val r = ja
      r
    case software.amazon.awssdk.services.workdocs.model.LocaleType.RU =>
      val r = ru
      r
    case software.amazon.awssdk.services.workdocs.model.LocaleType.ZH_CN =>
      val r = zh_CN
      r
    case software.amazon.awssdk.services.workdocs.model.LocaleType.ZH_TW =>
      val r = zh_TW
      r
    case software.amazon.awssdk.services.workdocs.model.LocaleType.PT_BR =>
      val r = pt_BR
      r
    case software.amazon.awssdk.services.workdocs.model.LocaleType.DEFAULT =>
      val r = default
      r
  }
  case object unknownToSdkVersion extends zio.aws.workdocs.model.LocaleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.LocaleType =
      software.amazon.awssdk.services.workdocs.model.LocaleType.UNKNOWN_TO_SDK_VERSION
  }
  case object en extends zio.aws.workdocs.model.LocaleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.LocaleType =
      software.amazon.awssdk.services.workdocs.model.LocaleType.EN
  }
  case object fr extends zio.aws.workdocs.model.LocaleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.LocaleType =
      software.amazon.awssdk.services.workdocs.model.LocaleType.FR
  }
  case object ko extends zio.aws.workdocs.model.LocaleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.LocaleType =
      software.amazon.awssdk.services.workdocs.model.LocaleType.KO
  }
  case object de extends zio.aws.workdocs.model.LocaleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.LocaleType =
      software.amazon.awssdk.services.workdocs.model.LocaleType.DE
  }
  case object es extends zio.aws.workdocs.model.LocaleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.LocaleType =
      software.amazon.awssdk.services.workdocs.model.LocaleType.ES
  }
  case object ja extends zio.aws.workdocs.model.LocaleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.LocaleType =
      software.amazon.awssdk.services.workdocs.model.LocaleType.JA
  }
  case object ru extends zio.aws.workdocs.model.LocaleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.LocaleType =
      software.amazon.awssdk.services.workdocs.model.LocaleType.RU
  }
  case object zh_CN extends zio.aws.workdocs.model.LocaleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.LocaleType =
      software.amazon.awssdk.services.workdocs.model.LocaleType.ZH_CN
  }
  case object zh_TW extends zio.aws.workdocs.model.LocaleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.LocaleType =
      software.amazon.awssdk.services.workdocs.model.LocaleType.ZH_TW
  }
  case object pt_BR extends zio.aws.workdocs.model.LocaleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.LocaleType =
      software.amazon.awssdk.services.workdocs.model.LocaleType.PT_BR
  }
  case object default extends zio.aws.workdocs.model.LocaleType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.LocaleType =
      software.amazon.awssdk.services.workdocs.model.LocaleType.DEFAULT
  }
}
