package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  ResourceNameType,
  ResourceIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class UpdateDocumentRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    documentId: ResourceIdType,
    name: Option[ResourceNameType] = None,
    parentFolderId: Option[ResourceIdType] = None,
    resourceState: Option[zio.aws.workdocs.model.ResourceStateType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.UpdateDocumentRequest = {
    import UpdateDocumentRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.UpdateDocumentRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .documentId(ResourceIdType.unwrap(documentId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        parentFolderId.map(value =>
          ResourceIdType.unwrap(value): java.lang.String
        )
      )(_.parentFolderId)
      .optionallyWith(resourceState.map(value => value.unwrap))(_.resourceState)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.UpdateDocumentRequest.ReadOnly =
    zio.aws.workdocs.model.UpdateDocumentRequest.wrap(buildAwsValue())
}
object UpdateDocumentRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.UpdateDocumentRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.UpdateDocumentRequest =
      zio.aws.workdocs.model.UpdateDocumentRequest(
        authenticationToken.map(value => value),
        documentId,
        name.map(value => value),
        parentFolderId.map(value => value),
        resourceState.map(value => value)
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def documentId: ResourceIdType
    def name: Option[ResourceNameType]
    def parentFolderId: Option[ResourceIdType]
    def resourceState: Option[zio.aws.workdocs.model.ResourceStateType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getDocumentId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(documentId)
    def getName: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("name", name)
    def getParentFolderId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("parentFolderId", parentFolderId)
    def getResourceState
        : ZIO[Any, AwsError, zio.aws.workdocs.model.ResourceStateType] =
      AwsError.unwrapOptionField("resourceState", resourceState)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.UpdateDocumentRequest
  ) extends zio.aws.workdocs.model.UpdateDocumentRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val documentId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.documentId())
    override val name: Option[ResourceNameType] = scala
      .Option(impl.name())
      .map(value => zio.aws.workdocs.model.primitives.ResourceNameType(value))
    override val parentFolderId: Option[ResourceIdType] = scala
      .Option(impl.parentFolderId())
      .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val resourceState
        : Option[zio.aws.workdocs.model.ResourceStateType] = scala
      .Option(impl.resourceState())
      .map(value => zio.aws.workdocs.model.ResourceStateType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.UpdateDocumentRequest
  ): zio.aws.workdocs.model.UpdateDocumentRequest.ReadOnly = new Wrapper(impl)
}
