package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.workdocs.model.primitives.{
  UrlType,
  IdType,
  DocumentContentType,
  ResourceNameType,
  TimestampType,
  HashType,
  DocumentVersionIdType,
  SizeType
}
import scala.jdk.CollectionConverters.*
final case class DocumentVersionMetadata(
    id: Option[DocumentVersionIdType] = None,
    name: Option[ResourceNameType] = None,
    contentType: Option[DocumentContentType] = None,
    size: Option[SizeType] = None,
    signature: Option[HashType] = None,
    status: Option[zio.aws.workdocs.model.DocumentStatusType] = None,
    createdTimestamp: Option[TimestampType] = None,
    modifiedTimestamp: Option[TimestampType] = None,
    contentCreatedTimestamp: Option[TimestampType] = None,
    contentModifiedTimestamp: Option[TimestampType] = None,
    creatorId: Option[IdType] = None,
    thumbnail: Option[
      Map[zio.aws.workdocs.model.DocumentThumbnailType, UrlType]
    ] = None,
    source: Option[Map[zio.aws.workdocs.model.DocumentSourceType, UrlType]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata = {
    import DocumentVersionMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata
      .builder()
      .optionallyWith(
        id.map(value => DocumentVersionIdType.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        name.map(value => ResourceNameType.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        contentType.map(value =>
          DocumentContentType.unwrap(value): java.lang.String
        )
      )(_.contentType)
      .optionallyWith(
        size.map(value => SizeType.unwrap(value): java.lang.Long)
      )(_.size)
      .optionallyWith(
        signature.map(value => HashType.unwrap(value): java.lang.String)
      )(_.signature)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        createdTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        modifiedTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.modifiedTimestamp)
      .optionallyWith(
        contentCreatedTimestamp.map(value =>
          TimestampType.unwrap(value): Instant
        )
      )(_.contentCreatedTimestamp)
      .optionallyWith(
        contentModifiedTimestamp.map(value =>
          TimestampType.unwrap(value): Instant
        )
      )(_.contentModifiedTimestamp)
      .optionallyWith(
        creatorId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.creatorId)
      .optionallyWith(
        thumbnail.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (UrlType.unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.thumbnailWithStrings)
      .optionallyWith(
        source.map(value =>
          value
            .map({ case (key, value) =>
              key.unwrap.toString -> (UrlType.unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.sourceWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly =
    zio.aws.workdocs.model.DocumentVersionMetadata.wrap(buildAwsValue())
}
object DocumentVersionMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DocumentVersionMetadata =
      zio.aws.workdocs.model.DocumentVersionMetadata(
        id.map(value => value),
        name.map(value => value),
        contentType.map(value => value),
        size.map(value => value),
        signature.map(value => value),
        status.map(value => value),
        createdTimestamp.map(value => value),
        modifiedTimestamp.map(value => value),
        contentCreatedTimestamp.map(value => value),
        contentModifiedTimestamp.map(value => value),
        creatorId.map(value => value),
        thumbnail.map(value => value),
        source.map(value => value)
      )
    def id: Option[DocumentVersionIdType]
    def name: Option[ResourceNameType]
    def contentType: Option[DocumentContentType]
    def size: Option[SizeType]
    def signature: Option[HashType]
    def status: Option[zio.aws.workdocs.model.DocumentStatusType]
    def createdTimestamp: Option[TimestampType]
    def modifiedTimestamp: Option[TimestampType]
    def contentCreatedTimestamp: Option[TimestampType]
    def contentModifiedTimestamp: Option[TimestampType]
    def creatorId: Option[IdType]
    def thumbnail
        : Option[Map[zio.aws.workdocs.model.DocumentThumbnailType, UrlType]]
    def source: Option[Map[zio.aws.workdocs.model.DocumentSourceType, UrlType]]
    def getId: ZIO[Any, AwsError, DocumentVersionIdType] =
      AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, ResourceNameType] =
      AwsError.unwrapOptionField("name", name)
    def getContentType: ZIO[Any, AwsError, DocumentContentType] =
      AwsError.unwrapOptionField("contentType", contentType)
    def getSize: ZIO[Any, AwsError, SizeType] =
      AwsError.unwrapOptionField("size", size)
    def getSignature: ZIO[Any, AwsError, HashType] =
      AwsError.unwrapOptionField("signature", signature)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.workdocs.model.DocumentStatusType] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getModifiedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("modifiedTimestamp", modifiedTimestamp)
    def getContentCreatedTimestamp: ZIO[Any, AwsError, TimestampType] = AwsError
      .unwrapOptionField("contentCreatedTimestamp", contentCreatedTimestamp)
    def getContentModifiedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField(
        "contentModifiedTimestamp",
        contentModifiedTimestamp
      )
    def getCreatorId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("creatorId", creatorId)
    def getThumbnail: ZIO[Any, AwsError, Map[
      zio.aws.workdocs.model.DocumentThumbnailType,
      UrlType
    ]] = AwsError.unwrapOptionField("thumbnail", thumbnail)
    def getSource: ZIO[Any, AwsError, Map[
      zio.aws.workdocs.model.DocumentSourceType,
      UrlType
    ]] = AwsError.unwrapOptionField("source", source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata
  ) extends zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly {
    override val id: Option[DocumentVersionIdType] = scala
      .Option(impl.id())
      .map(value =>
        zio.aws.workdocs.model.primitives.DocumentVersionIdType(value)
      )
    override val name: Option[ResourceNameType] = scala
      .Option(impl.name())
      .map(value => zio.aws.workdocs.model.primitives.ResourceNameType(value))
    override val contentType: Option[DocumentContentType] = scala
      .Option(impl.contentType())
      .map(value =>
        zio.aws.workdocs.model.primitives.DocumentContentType(value)
      )
    override val size: Option[SizeType] = scala
      .Option(impl.size())
      .map(value => zio.aws.workdocs.model.primitives.SizeType(value))
    override val signature: Option[HashType] = scala
      .Option(impl.signature())
      .map(value => zio.aws.workdocs.model.primitives.HashType(value))
    override val status: Option[zio.aws.workdocs.model.DocumentStatusType] =
      scala
        .Option(impl.status())
        .map(value => zio.aws.workdocs.model.DocumentStatusType.wrap(value))
    override val createdTimestamp: Option[TimestampType] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val modifiedTimestamp: Option[TimestampType] = scala
      .Option(impl.modifiedTimestamp())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val contentCreatedTimestamp: Option[TimestampType] = scala
      .Option(impl.contentCreatedTimestamp())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val contentModifiedTimestamp: Option[TimestampType] = scala
      .Option(impl.contentModifiedTimestamp())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val creatorId: Option[IdType] = scala
      .Option(impl.creatorId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val thumbnail
        : Option[Map[zio.aws.workdocs.model.DocumentThumbnailType, UrlType]] =
      scala
        .Option(impl.thumbnail())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.workdocs.model.DocumentThumbnailType
                .wrap(key) -> zio.aws.workdocs.model.primitives.UrlType(value)
            })
            .toMap
        )
    override val source
        : Option[Map[zio.aws.workdocs.model.DocumentSourceType, UrlType]] =
      scala
        .Option(impl.source())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.workdocs.model.DocumentSourceType
                .wrap(key) -> zio.aws.workdocs.model.primitives.UrlType(value)
            })
            .toMap
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DocumentVersionMetadata
  ): zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly = new Wrapper(impl)
}
