package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.SizeType
import scala.jdk.CollectionConverters.*
final case class UserStorageMetadata(
    storageUtilizedInBytes: Option[SizeType] = None,
    storageRule: Option[zio.aws.workdocs.model.StorageRuleType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.UserStorageMetadata = {
    import UserStorageMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.UserStorageMetadata
      .builder()
      .optionallyWith(
        storageUtilizedInBytes.map(value =>
          SizeType.unwrap(value): java.lang.Long
        )
      )(_.storageUtilizedInBytes)
      .optionallyWith(storageRule.map(value => value.buildAwsValue()))(
        _.storageRule
      )
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.UserStorageMetadata.ReadOnly =
    zio.aws.workdocs.model.UserStorageMetadata.wrap(buildAwsValue())
}
object UserStorageMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.UserStorageMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.UserStorageMetadata =
      zio.aws.workdocs.model.UserStorageMetadata(
        storageUtilizedInBytes.map(value => value),
        storageRule.map(value => value.asEditable)
      )
    def storageUtilizedInBytes: Option[SizeType]
    def storageRule: Option[zio.aws.workdocs.model.StorageRuleType.ReadOnly]
    def getStorageUtilizedInBytes: ZIO[Any, AwsError, SizeType] = AwsError
      .unwrapOptionField("storageUtilizedInBytes", storageUtilizedInBytes)
    def getStorageRule
        : ZIO[Any, AwsError, zio.aws.workdocs.model.StorageRuleType.ReadOnly] =
      AwsError.unwrapOptionField("storageRule", storageRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.UserStorageMetadata
  ) extends zio.aws.workdocs.model.UserStorageMetadata.ReadOnly {
    override val storageUtilizedInBytes: Option[SizeType] = scala
      .Option(impl.storageUtilizedInBytes())
      .map(value => zio.aws.workdocs.model.primitives.SizeType(value))
    override val storageRule
        : Option[zio.aws.workdocs.model.StorageRuleType.ReadOnly] = scala
      .Option(impl.storageRule())
      .map(value => zio.aws.workdocs.model.StorageRuleType.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.UserStorageMetadata
  ): zio.aws.workdocs.model.UserStorageMetadata.ReadOnly = new Wrapper(impl)
}
