package zio.aws.workdocs.model
import scala.jdk.CollectionConverters.*
sealed trait UserSortType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.UserSortType
}
object UserSortType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.UserSortType
  ): zio.aws.workdocs.model.UserSortType = value match {
    case software.amazon.awssdk.services.workdocs.model.UserSortType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.UserSortType.USER_NAME =>
      val r = USER_NAME
      r
    case software.amazon.awssdk.services.workdocs.model.UserSortType.FULL_NAME =>
      val r = FULL_NAME
      r
    case software.amazon.awssdk.services.workdocs.model.UserSortType.STORAGE_LIMIT =>
      val r = STORAGE_LIMIT
      r
    case software.amazon.awssdk.services.workdocs.model.UserSortType.USER_STATUS =>
      val r = USER_STATUS
      r
    case software.amazon.awssdk.services.workdocs.model.UserSortType.STORAGE_USED =>
      val r = STORAGE_USED
      r
  }
  case object unknownToSdkVersion extends zio.aws.workdocs.model.UserSortType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.UserSortType =
      software.amazon.awssdk.services.workdocs.model.UserSortType.UNKNOWN_TO_SDK_VERSION
  }
  case object USER_NAME extends zio.aws.workdocs.model.UserSortType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.UserSortType =
      software.amazon.awssdk.services.workdocs.model.UserSortType.USER_NAME
  }
  case object FULL_NAME extends zio.aws.workdocs.model.UserSortType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.UserSortType =
      software.amazon.awssdk.services.workdocs.model.UserSortType.FULL_NAME
  }
  case object STORAGE_LIMIT extends zio.aws.workdocs.model.UserSortType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.UserSortType =
      software.amazon.awssdk.services.workdocs.model.UserSortType.STORAGE_LIMIT
  }
  case object USER_STATUS extends zio.aws.workdocs.model.UserSortType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.UserSortType =
      software.amazon.awssdk.services.workdocs.model.UserSortType.USER_STATUS
  }
  case object STORAGE_USED extends zio.aws.workdocs.model.UserSortType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.UserSortType =
      software.amazon.awssdk.services.workdocs.model.UserSortType.STORAGE_USED
  }
}
