package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  ResourceIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class DeleteFolderRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    folderId: ResourceIdType
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DeleteFolderRequest = {
    import DeleteFolderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DeleteFolderRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .folderId(ResourceIdType.unwrap(folderId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DeleteFolderRequest.ReadOnly =
    zio.aws.workdocs.model.DeleteFolderRequest.wrap(buildAwsValue())
}
object DeleteFolderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DeleteFolderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DeleteFolderRequest =
      zio.aws.workdocs.model
        .DeleteFolderRequest(authenticationToken.map(value => value), folderId)
    def authenticationToken: Option[AuthenticationHeaderType]
    def folderId: ResourceIdType
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getFolderId: ZIO[Any, Nothing, ResourceIdType] = ZIO.succeed(folderId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteFolderRequest
  ) extends zio.aws.workdocs.model.DeleteFolderRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val folderId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.folderId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DeleteFolderRequest
  ): zio.aws.workdocs.model.DeleteFolderRequest.ReadOnly = new Wrapper(impl)
}
