package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import scala.jdk.CollectionConverters.*
final case class InitiateDocumentVersionUploadResponse(
    metadata: Option[zio.aws.workdocs.model.DocumentMetadata] = None,
    uploadMetadata: Option[zio.aws.workdocs.model.UploadMetadata] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadResponse = {
    import InitiateDocumentVersionUploadResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadResponse
      .builder()
      .optionallyWith(metadata.map(value => value.buildAwsValue()))(_.metadata)
      .optionallyWith(uploadMetadata.map(value => value.buildAwsValue()))(
        _.uploadMetadata
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse.ReadOnly =
    zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse
      .wrap(buildAwsValue())
}
object InitiateDocumentVersionUploadResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse =
      zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse(
        metadata.map(value => value.asEditable),
        uploadMetadata.map(value => value.asEditable)
      )
    def metadata: Option[zio.aws.workdocs.model.DocumentMetadata.ReadOnly]
    def uploadMetadata: Option[zio.aws.workdocs.model.UploadMetadata.ReadOnly]
    def getMetadata
        : ZIO[Any, AwsError, zio.aws.workdocs.model.DocumentMetadata.ReadOnly] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getUploadMetadata
        : ZIO[Any, AwsError, zio.aws.workdocs.model.UploadMetadata.ReadOnly] =
      AwsError.unwrapOptionField("uploadMetadata", uploadMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadResponse
  ) extends zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse.ReadOnly {
    override val metadata
        : Option[zio.aws.workdocs.model.DocumentMetadata.ReadOnly] = scala
      .Option(impl.metadata())
      .map(value => zio.aws.workdocs.model.DocumentMetadata.wrap(value))
    override val uploadMetadata
        : Option[zio.aws.workdocs.model.UploadMetadata.ReadOnly] = scala
      .Option(impl.uploadMetadata())
      .map(value => zio.aws.workdocs.model.UploadMetadata.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.InitiateDocumentVersionUploadResponse
  ): zio.aws.workdocs.model.InitiateDocumentVersionUploadResponse.ReadOnly =
    new Wrapper(impl)
}
