package zio.aws.workdocs.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{LimitType, PageMarkerType, IdType}
import scala.jdk.CollectionConverters.*
final case class DescribeNotificationSubscriptionsRequest(
    organizationId: IdType,
    marker: Option[PageMarkerType] = None,
    limit: Option[LimitType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest = {
    import DescribeNotificationSubscriptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest
      .builder()
      .organizationId(IdType.unwrap(organizationId): java.lang.String)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest.ReadOnly =
    zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest
      .wrap(buildAwsValue())
}
object DescribeNotificationSubscriptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest =
      zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest(
        organizationId,
        marker.map(value => value),
        limit.map(value => value)
      )
    def organizationId: IdType
    def marker: Option[PageMarkerType]
    def limit: Option[LimitType]
    def getOrganizationId: ZIO[Any, Nothing, IdType] =
      ZIO.succeed(organizationId)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest
  ) extends zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest.ReadOnly {
    override val organizationId: IdType =
      zio.aws.workdocs.model.primitives.IdType(impl.organizationId())
    override val marker: Option[PageMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
    override val limit: Option[LimitType] = scala
      .Option(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsRequest
  ): zio.aws.workdocs.model.DescribeNotificationSubscriptionsRequest.ReadOnly =
    new Wrapper(impl)
}
