package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  DocumentVersionIdType,
  ResourceIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class UpdateDocumentVersionRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    documentId: ResourceIdType,
    versionId: DocumentVersionIdType,
    versionStatus: Option[zio.aws.workdocs.model.DocumentVersionStatus] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionRequest = {
    import UpdateDocumentVersionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .documentId(ResourceIdType.unwrap(documentId): java.lang.String)
      .versionId(DocumentVersionIdType.unwrap(versionId): java.lang.String)
      .optionallyWith(versionStatus.map(value => value.unwrap))(_.versionStatus)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.UpdateDocumentVersionRequest.ReadOnly =
    zio.aws.workdocs.model.UpdateDocumentVersionRequest.wrap(buildAwsValue())
}
object UpdateDocumentVersionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.UpdateDocumentVersionRequest =
      zio.aws.workdocs.model.UpdateDocumentVersionRequest(
        authenticationToken.map(value => value),
        documentId,
        versionId,
        versionStatus.map(value => value)
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def documentId: ResourceIdType
    def versionId: DocumentVersionIdType
    def versionStatus: Option[zio.aws.workdocs.model.DocumentVersionStatus]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getDocumentId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(documentId)
    def getVersionId: ZIO[Any, Nothing, DocumentVersionIdType] =
      ZIO.succeed(versionId)
    def getVersionStatus
        : ZIO[Any, AwsError, zio.aws.workdocs.model.DocumentVersionStatus] =
      AwsError.unwrapOptionField("versionStatus", versionStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionRequest
  ) extends zio.aws.workdocs.model.UpdateDocumentVersionRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val documentId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.documentId())
    override val versionId: DocumentVersionIdType =
      zio.aws.workdocs.model.primitives.DocumentVersionIdType(impl.versionId())
    override val versionStatus
        : Option[zio.aws.workdocs.model.DocumentVersionStatus] = scala
      .Option(impl.versionStatus())
      .map(value => zio.aws.workdocs.model.DocumentVersionStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.UpdateDocumentVersionRequest
  ): zio.aws.workdocs.model.UpdateDocumentVersionRequest.ReadOnly = new Wrapper(
    impl
  )
}
