package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  PasswordType,
  IdType,
  UsernameType,
  EmailAddressType,
  UserAttributeValueType,
  TimeZoneIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class CreateUserRequest(
    organizationId: Option[IdType] = None,
    username: UsernameType,
    emailAddress: Option[EmailAddressType] = None,
    givenName: UserAttributeValueType,
    surname: UserAttributeValueType,
    password: PasswordType,
    timeZoneId: Option[TimeZoneIdType] = None,
    storageRule: Option[zio.aws.workdocs.model.StorageRuleType] = None,
    authenticationToken: Option[AuthenticationHeaderType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.CreateUserRequest = {
    import CreateUserRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.CreateUserRequest
      .builder()
      .optionallyWith(
        organizationId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.organizationId)
      .username(UsernameType.unwrap(username): java.lang.String)
      .optionallyWith(
        emailAddress.map(value =>
          EmailAddressType.unwrap(value): java.lang.String
        )
      )(_.emailAddress)
      .givenName(UserAttributeValueType.unwrap(givenName): java.lang.String)
      .surname(UserAttributeValueType.unwrap(surname): java.lang.String)
      .password(PasswordType.unwrap(password): java.lang.String)
      .optionallyWith(
        timeZoneId.map(value => TimeZoneIdType.unwrap(value): java.lang.String)
      )(_.timeZoneId)
      .optionallyWith(storageRule.map(value => value.buildAwsValue()))(
        _.storageRule
      )
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.CreateUserRequest.ReadOnly =
    zio.aws.workdocs.model.CreateUserRequest.wrap(buildAwsValue())
}
object CreateUserRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.CreateUserRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.CreateUserRequest =
      zio.aws.workdocs.model.CreateUserRequest(
        organizationId.map(value => value),
        username,
        emailAddress.map(value => value),
        givenName,
        surname,
        password,
        timeZoneId.map(value => value),
        storageRule.map(value => value.asEditable),
        authenticationToken.map(value => value)
      )
    def organizationId: Option[IdType]
    def username: UsernameType
    def emailAddress: Option[EmailAddressType]
    def givenName: UserAttributeValueType
    def surname: UserAttributeValueType
    def password: PasswordType
    def timeZoneId: Option[TimeZoneIdType]
    def storageRule: Option[zio.aws.workdocs.model.StorageRuleType.ReadOnly]
    def authenticationToken: Option[AuthenticationHeaderType]
    def getOrganizationId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("organizationId", organizationId)
    def getUsername: ZIO[Any, Nothing, UsernameType] = ZIO.succeed(username)
    def getEmailAddress: ZIO[Any, AwsError, EmailAddressType] =
      AwsError.unwrapOptionField("emailAddress", emailAddress)
    def getGivenName: ZIO[Any, Nothing, UserAttributeValueType] =
      ZIO.succeed(givenName)
    def getSurname: ZIO[Any, Nothing, UserAttributeValueType] =
      ZIO.succeed(surname)
    def getPassword: ZIO[Any, Nothing, PasswordType] = ZIO.succeed(password)
    def getTimeZoneId: ZIO[Any, AwsError, TimeZoneIdType] =
      AwsError.unwrapOptionField("timeZoneId", timeZoneId)
    def getStorageRule
        : ZIO[Any, AwsError, zio.aws.workdocs.model.StorageRuleType.ReadOnly] =
      AwsError.unwrapOptionField("storageRule", storageRule)
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.CreateUserRequest
  ) extends zio.aws.workdocs.model.CreateUserRequest.ReadOnly {
    override val organizationId: Option[IdType] = scala
      .Option(impl.organizationId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val username: UsernameType =
      zio.aws.workdocs.model.primitives.UsernameType(impl.username())
    override val emailAddress: Option[EmailAddressType] = scala
      .Option(impl.emailAddress())
      .map(value => zio.aws.workdocs.model.primitives.EmailAddressType(value))
    override val givenName: UserAttributeValueType =
      zio.aws.workdocs.model.primitives.UserAttributeValueType(impl.givenName())
    override val surname: UserAttributeValueType =
      zio.aws.workdocs.model.primitives.UserAttributeValueType(impl.surname())
    override val password: PasswordType =
      zio.aws.workdocs.model.primitives.PasswordType(impl.password())
    override val timeZoneId: Option[TimeZoneIdType] = scala
      .Option(impl.timeZoneId())
      .map(value => zio.aws.workdocs.model.primitives.TimeZoneIdType(value))
    override val storageRule
        : Option[zio.aws.workdocs.model.StorageRuleType.ReadOnly] = scala
      .Option(impl.storageRule())
      .map(value => zio.aws.workdocs.model.StorageRuleType.wrap(value))
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.CreateUserRequest
  ): zio.aws.workdocs.model.CreateUserRequest.ReadOnly = new Wrapper(impl)
}
