package zio.aws.workdocs.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  IdType,
  FieldNamesType,
  PageMarkerType,
  LimitType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class GetDocumentPathRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    documentId: IdType,
    limit: Option[LimitType] = None,
    fields: Option[FieldNamesType] = None,
    marker: Option[PageMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest = {
    import GetDocumentPathRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .documentId(IdType.unwrap(documentId): java.lang.String)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        fields.map(value => FieldNamesType.unwrap(value): java.lang.String)
      )(_.fields)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GetDocumentPathRequest.ReadOnly =
    zio.aws.workdocs.model.GetDocumentPathRequest.wrap(buildAwsValue())
}
object GetDocumentPathRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GetDocumentPathRequest =
      zio.aws.workdocs.model.GetDocumentPathRequest(
        authenticationToken.map(value => value),
        documentId,
        limit.map(value => value),
        fields.map(value => value),
        marker.map(value => value)
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def documentId: IdType
    def limit: Option[LimitType]
    def fields: Option[FieldNamesType]
    def marker: Option[PageMarkerType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getDocumentId: ZIO[Any, Nothing, IdType] = ZIO.succeed(documentId)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getFields: ZIO[Any, AwsError, FieldNamesType] =
      AwsError.unwrapOptionField("fields", fields)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest
  ) extends zio.aws.workdocs.model.GetDocumentPathRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val documentId: IdType =
      zio.aws.workdocs.model.primitives.IdType(impl.documentId())
    override val limit: Option[LimitType] = scala
      .Option(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val fields: Option[FieldNamesType] = scala
      .Option(impl.fields())
      .map(value => zio.aws.workdocs.model.primitives.FieldNamesType(value))
    override val marker: Option[PageMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GetDocumentPathRequest
  ): zio.aws.workdocs.model.GetDocumentPathRequest.ReadOnly = new Wrapper(impl)
}
