package zio.aws.workdocs.model
import zio.aws.workdocs.model.primitives.{
  BooleanType,
  IdType,
  TimestampType,
  ActivityNamesFilterType,
  LimitType,
  MarkerType,
  AuthenticationHeaderType
}
import java.time.Instant
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DescribeActivitiesRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    startTime: Option[TimestampType] = None,
    endTime: Option[TimestampType] = None,
    organizationId: Option[IdType] = None,
    activityTypes: Option[ActivityNamesFilterType] = None,
    resourceId: Option[IdType] = None,
    userId: Option[IdType] = None,
    includeIndirectActivities: Option[BooleanType] = None,
    limit: Option[LimitType] = None,
    marker: Option[MarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest = {
    import DescribeActivitiesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .optionallyWith(
        startTime.map(value => TimestampType.unwrap(value): Instant)
      )(_.startTime)
      .optionallyWith(
        endTime.map(value => TimestampType.unwrap(value): Instant)
      )(_.endTime)
      .optionallyWith(
        organizationId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.organizationId)
      .optionallyWith(
        activityTypes.map(value =>
          ActivityNamesFilterType.unwrap(value): java.lang.String
        )
      )(_.activityTypes)
      .optionallyWith(
        resourceId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.resourceId)
      .optionallyWith(
        userId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(
        includeIndirectActivities.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.includeIndirectActivities)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DescribeActivitiesRequest.ReadOnly =
    zio.aws.workdocs.model.DescribeActivitiesRequest.wrap(buildAwsValue())
}
object DescribeActivitiesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeActivitiesRequest =
      zio.aws.workdocs.model.DescribeActivitiesRequest(
        authenticationToken.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value),
        organizationId.map(value => value),
        activityTypes.map(value => value),
        resourceId.map(value => value),
        userId.map(value => value),
        includeIndirectActivities.map(value => value),
        limit.map(value => value),
        marker.map(value => value)
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def startTime: Option[TimestampType]
    def endTime: Option[TimestampType]
    def organizationId: Option[IdType]
    def activityTypes: Option[ActivityNamesFilterType]
    def resourceId: Option[IdType]
    def userId: Option[IdType]
    def includeIndirectActivities: Option[BooleanType]
    def limit: Option[LimitType]
    def marker: Option[MarkerType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getStartTime: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("endTime", endTime)
    def getOrganizationId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("organizationId", organizationId)
    def getActivityTypes: ZIO[Any, AwsError, ActivityNamesFilterType] =
      AwsError.unwrapOptionField("activityTypes", activityTypes)
    def getResourceId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("resourceId", resourceId)
    def getUserId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("userId", userId)
    def getIncludeIndirectActivities: ZIO[Any, AwsError, BooleanType] = AwsError
      .unwrapOptionField("includeIndirectActivities", includeIndirectActivities)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest
  ) extends zio.aws.workdocs.model.DescribeActivitiesRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val startTime: Option[TimestampType] = scala
      .Option(impl.startTime())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val endTime: Option[TimestampType] = scala
      .Option(impl.endTime())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val organizationId: Option[IdType] = scala
      .Option(impl.organizationId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val activityTypes: Option[ActivityNamesFilterType] = scala
      .Option(impl.activityTypes())
      .map(value =>
        zio.aws.workdocs.model.primitives.ActivityNamesFilterType(value)
      )
    override val resourceId: Option[IdType] = scala
      .Option(impl.resourceId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val userId: Option[IdType] = scala
      .Option(impl.userId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val includeIndirectActivities: Option[BooleanType] = scala
      .Option(impl.includeIndirectActivities())
      .map(value => zio.aws.workdocs.model.primitives.BooleanType(value))
    override val limit: Option[LimitType] = scala
      .Option(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeActivitiesRequest
  ): zio.aws.workdocs.model.DescribeActivitiesRequest.ReadOnly = new Wrapper(
    impl
  )
}
