package zio.aws.workdocs.model
import scala.jdk.CollectionConverters.*
sealed trait StorageType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.StorageType
}
object StorageType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.StorageType
  ): zio.aws.workdocs.model.StorageType = value match {
    case software.amazon.awssdk.services.workdocs.model.StorageType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.StorageType.UNLIMITED =>
      val r = UNLIMITED
      r
    case software.amazon.awssdk.services.workdocs.model.StorageType.QUOTA =>
      val r = QUOTA
      r
  }
  case object unknownToSdkVersion extends zio.aws.workdocs.model.StorageType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.StorageType =
      software.amazon.awssdk.services.workdocs.model.StorageType.UNKNOWN_TO_SDK_VERSION
  }
  case object UNLIMITED extends zio.aws.workdocs.model.StorageType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.StorageType =
      software.amazon.awssdk.services.workdocs.model.StorageType.UNLIMITED
  }
  case object QUOTA extends zio.aws.workdocs.model.StorageType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.StorageType =
      software.amazon.awssdk.services.workdocs.model.StorageType.QUOTA
  }
}
