package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.PageMarkerType
import scala.jdk.CollectionConverters.*
final case class DescribeNotificationSubscriptionsResponse(
    subscriptions: Option[Iterable[zio.aws.workdocs.model.Subscription]] = None,
    marker: Option[PageMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse = {
    import DescribeNotificationSubscriptionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse
      .builder()
      .optionallyWith(
        subscriptions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.subscriptions)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.DescribeNotificationSubscriptionsResponse.ReadOnly =
    zio.aws.workdocs.model.DescribeNotificationSubscriptionsResponse
      .wrap(buildAwsValue())
}
object DescribeNotificationSubscriptionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.workdocs.model.DescribeNotificationSubscriptionsResponse =
      zio.aws.workdocs.model.DescribeNotificationSubscriptionsResponse(
        subscriptions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def subscriptions
        : Option[List[zio.aws.workdocs.model.Subscription.ReadOnly]]
    def marker: Option[PageMarkerType]
    def getSubscriptions: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.Subscription.ReadOnly
    ]] = AwsError.unwrapOptionField("subscriptions", subscriptions)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse
  ) extends zio.aws.workdocs.model.DescribeNotificationSubscriptionsResponse.ReadOnly {
    override val subscriptions
        : Option[List[zio.aws.workdocs.model.Subscription.ReadOnly]] = scala
      .Option(impl.subscriptions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workdocs.model.Subscription.wrap(item)
        }.toList
      )
    override val marker: Option[PageMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeNotificationSubscriptionsResponse
  ): zio.aws.workdocs.model.DescribeNotificationSubscriptionsResponse.ReadOnly =
    new Wrapper(impl)
}
