package zio.aws.workdocs.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  SearchQueryType,
  IdType,
  PositiveIntegerType,
  MarkerType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class DescribeGroupsRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    searchQuery: SearchQueryType,
    organizationId: Option[IdType] = None,
    marker: Option[MarkerType] = None,
    limit: Option[PositiveIntegerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest = {
    import DescribeGroupsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .searchQuery(SearchQueryType.unwrap(searchQuery): java.lang.String)
      .optionallyWith(
        organizationId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.organizationId)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .optionallyWith(
        limit.map(value => PositiveIntegerType.unwrap(value): Integer)
      )(_.limit)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DescribeGroupsRequest.ReadOnly =
    zio.aws.workdocs.model.DescribeGroupsRequest.wrap(buildAwsValue())
}
object DescribeGroupsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeGroupsRequest =
      zio.aws.workdocs.model.DescribeGroupsRequest(
        authenticationToken.map(value => value),
        searchQuery,
        organizationId.map(value => value),
        marker.map(value => value),
        limit.map(value => value)
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def searchQuery: SearchQueryType
    def organizationId: Option[IdType]
    def marker: Option[MarkerType]
    def limit: Option[PositiveIntegerType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getSearchQuery: ZIO[Any, Nothing, SearchQueryType] =
      ZIO.succeed(searchQuery)
    def getOrganizationId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("organizationId", organizationId)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
    def getLimit: ZIO[Any, AwsError, PositiveIntegerType] =
      AwsError.unwrapOptionField("limit", limit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest
  ) extends zio.aws.workdocs.model.DescribeGroupsRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val searchQuery: SearchQueryType =
      zio.aws.workdocs.model.primitives.SearchQueryType(impl.searchQuery())
    override val organizationId: Option[IdType] = scala
      .Option(impl.organizationId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.MarkerType(value))
    override val limit: Option[PositiveIntegerType] = scala
      .Option(impl.limit())
      .map(value =>
        zio.aws.workdocs.model.primitives.PositiveIntegerType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeGroupsRequest
  ): zio.aws.workdocs.model.DescribeGroupsRequest.ReadOnly = new Wrapper(impl)
}
