package zio.aws.workdocs.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  DocumentVersionIdType,
  LimitType,
  MarkerType,
  AuthenticationHeaderType,
  ResourceIdType
}
import scala.jdk.CollectionConverters.*
final case class DescribeCommentsRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    documentId: ResourceIdType,
    versionId: DocumentVersionIdType,
    limit: Option[LimitType] = None,
    marker: Option[MarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest = {
    import DescribeCommentsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .documentId(ResourceIdType.unwrap(documentId): java.lang.String)
      .versionId(DocumentVersionIdType.unwrap(versionId): java.lang.String)
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DescribeCommentsRequest.ReadOnly =
    zio.aws.workdocs.model.DescribeCommentsRequest.wrap(buildAwsValue())
}
object DescribeCommentsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeCommentsRequest =
      zio.aws.workdocs.model.DescribeCommentsRequest(
        authenticationToken.map(value => value),
        documentId,
        versionId,
        limit.map(value => value),
        marker.map(value => value)
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def documentId: ResourceIdType
    def versionId: DocumentVersionIdType
    def limit: Option[LimitType]
    def marker: Option[MarkerType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getDocumentId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(documentId)
    def getVersionId: ZIO[Any, Nothing, DocumentVersionIdType] =
      ZIO.succeed(versionId)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest
  ) extends zio.aws.workdocs.model.DescribeCommentsRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val documentId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.documentId())
    override val versionId: DocumentVersionIdType =
      zio.aws.workdocs.model.primitives.DocumentVersionIdType(impl.versionId())
    override val limit: Option[LimitType] = scala
      .Option(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeCommentsRequest
  ): zio.aws.workdocs.model.DescribeCommentsRequest.ReadOnly = new Wrapper(impl)
}
