package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.workdocs.model.primitives.{IdType, TimestampType, CommentIdType}
import scala.jdk.CollectionConverters.*
final case class CommentMetadata(
    commentId: Option[CommentIdType] = None,
    contributor: Option[zio.aws.workdocs.model.User] = None,
    createdTimestamp: Option[TimestampType] = None,
    commentStatus: Option[zio.aws.workdocs.model.CommentStatusType] = None,
    recipientId: Option[IdType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.CommentMetadata = {
    import CommentMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.CommentMetadata
      .builder()
      .optionallyWith(
        commentId.map(value => CommentIdType.unwrap(value): java.lang.String)
      )(_.commentId)
      .optionallyWith(contributor.map(value => value.buildAwsValue()))(
        _.contributor
      )
      .optionallyWith(
        createdTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(commentStatus.map(value => value.unwrap))(_.commentStatus)
      .optionallyWith(
        recipientId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.recipientId)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.CommentMetadata.ReadOnly =
    zio.aws.workdocs.model.CommentMetadata.wrap(buildAwsValue())
}
object CommentMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.CommentMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.CommentMetadata =
      zio.aws.workdocs.model.CommentMetadata(
        commentId.map(value => value),
        contributor.map(value => value.asEditable),
        createdTimestamp.map(value => value),
        commentStatus.map(value => value),
        recipientId.map(value => value)
      )
    def commentId: Option[CommentIdType]
    def contributor: Option[zio.aws.workdocs.model.User.ReadOnly]
    def createdTimestamp: Option[TimestampType]
    def commentStatus: Option[zio.aws.workdocs.model.CommentStatusType]
    def recipientId: Option[IdType]
    def getCommentId: ZIO[Any, AwsError, CommentIdType] =
      AwsError.unwrapOptionField("commentId", commentId)
    def getContributor
        : ZIO[Any, AwsError, zio.aws.workdocs.model.User.ReadOnly] =
      AwsError.unwrapOptionField("contributor", contributor)
    def getCreatedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getCommentStatus
        : ZIO[Any, AwsError, zio.aws.workdocs.model.CommentStatusType] =
      AwsError.unwrapOptionField("commentStatus", commentStatus)
    def getRecipientId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("recipientId", recipientId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.CommentMetadata
  ) extends zio.aws.workdocs.model.CommentMetadata.ReadOnly {
    override val commentId: Option[CommentIdType] = scala
      .Option(impl.commentId())
      .map(value => zio.aws.workdocs.model.primitives.CommentIdType(value))
    override val contributor: Option[zio.aws.workdocs.model.User.ReadOnly] =
      scala
        .Option(impl.contributor())
        .map(value => zio.aws.workdocs.model.User.wrap(value))
    override val createdTimestamp: Option[TimestampType] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val commentStatus
        : Option[zio.aws.workdocs.model.CommentStatusType] = scala
      .Option(impl.commentStatus())
      .map(value => zio.aws.workdocs.model.CommentStatusType.wrap(value))
    override val recipientId: Option[IdType] = scala
      .Option(impl.recipientId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.CommentMetadata
  ): zio.aws.workdocs.model.CommentMetadata.ReadOnly = new Wrapper(impl)
}
