package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.MarkerType
import scala.jdk.CollectionConverters.*
final case class DescribeActivitiesResponse(
    userActivities: Option[Iterable[zio.aws.workdocs.model.Activity]] = None,
    marker: Option[MarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse = {
    import DescribeActivitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse
      .builder()
      .optionallyWith(
        userActivities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.userActivities)
      .optionallyWith(
        marker.map(value => MarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DescribeActivitiesResponse.ReadOnly =
    zio.aws.workdocs.model.DescribeActivitiesResponse.wrap(buildAwsValue())
}
object DescribeActivitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeActivitiesResponse =
      zio.aws.workdocs.model.DescribeActivitiesResponse(
        userActivities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def userActivities: Option[List[zio.aws.workdocs.model.Activity.ReadOnly]]
    def marker: Option[MarkerType]
    def getUserActivities
        : ZIO[Any, AwsError, List[zio.aws.workdocs.model.Activity.ReadOnly]] =
      AwsError.unwrapOptionField("userActivities", userActivities)
    def getMarker: ZIO[Any, AwsError, MarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse
  ) extends zio.aws.workdocs.model.DescribeActivitiesResponse.ReadOnly {
    override val userActivities
        : Option[List[zio.aws.workdocs.model.Activity.ReadOnly]] = scala
      .Option(impl.userActivities())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workdocs.model.Activity.wrap(item)
        }.toList
      )
    override val marker: Option[MarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.MarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeActivitiesResponse
  ): zio.aws.workdocs.model.DescribeActivitiesResponse.ReadOnly = new Wrapper(
    impl
  )
}
