package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.workdocs.model.primitives.{
  SharedLabel,
  TimestampType,
  IdType,
  ResourceIdType
}
import scala.jdk.CollectionConverters.*
final case class DocumentMetadata(
    id: Option[ResourceIdType] = None,
    creatorId: Option[IdType] = None,
    parentFolderId: Option[ResourceIdType] = None,
    createdTimestamp: Option[TimestampType] = None,
    modifiedTimestamp: Option[TimestampType] = None,
    latestVersionMetadata: Option[
      zio.aws.workdocs.model.DocumentVersionMetadata
    ] = None,
    resourceState: Option[zio.aws.workdocs.model.ResourceStateType] = None,
    labels: Option[Iterable[SharedLabel]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DocumentMetadata = {
    import DocumentMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DocumentMetadata
      .builder()
      .optionallyWith(
        id.map(value => ResourceIdType.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        creatorId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.creatorId)
      .optionallyWith(
        parentFolderId.map(value =>
          ResourceIdType.unwrap(value): java.lang.String
        )
      )(_.parentFolderId)
      .optionallyWith(
        createdTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        modifiedTimestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.modifiedTimestamp)
      .optionallyWith(
        latestVersionMetadata.map(value => value.buildAwsValue())
      )(_.latestVersionMetadata)
      .optionallyWith(resourceState.map(value => value.unwrap))(_.resourceState)
      .optionallyWith(
        labels.map(value =>
          value.map { item =>
            SharedLabel.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.labels)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.DocumentMetadata.ReadOnly =
    zio.aws.workdocs.model.DocumentMetadata.wrap(buildAwsValue())
}
object DocumentMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DocumentMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DocumentMetadata =
      zio.aws.workdocs.model.DocumentMetadata(
        id.map(value => value),
        creatorId.map(value => value),
        parentFolderId.map(value => value),
        createdTimestamp.map(value => value),
        modifiedTimestamp.map(value => value),
        latestVersionMetadata.map(value => value.asEditable),
        resourceState.map(value => value),
        labels.map(value => value)
      )
    def id: Option[ResourceIdType]
    def creatorId: Option[IdType]
    def parentFolderId: Option[ResourceIdType]
    def createdTimestamp: Option[TimestampType]
    def modifiedTimestamp: Option[TimestampType]
    def latestVersionMetadata
        : Option[zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly]
    def resourceState: Option[zio.aws.workdocs.model.ResourceStateType]
    def labels: Option[List[SharedLabel]]
    def getId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("id", id)
    def getCreatorId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("creatorId", creatorId)
    def getParentFolderId: ZIO[Any, AwsError, ResourceIdType] =
      AwsError.unwrapOptionField("parentFolderId", parentFolderId)
    def getCreatedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getModifiedTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("modifiedTimestamp", modifiedTimestamp)
    def getLatestVersionMetadata: ZIO[
      Any,
      AwsError,
      zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly
    ] =
      AwsError.unwrapOptionField("latestVersionMetadata", latestVersionMetadata)
    def getResourceState
        : ZIO[Any, AwsError, zio.aws.workdocs.model.ResourceStateType] =
      AwsError.unwrapOptionField("resourceState", resourceState)
    def getLabels: ZIO[Any, AwsError, List[SharedLabel]] =
      AwsError.unwrapOptionField("labels", labels)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DocumentMetadata
  ) extends zio.aws.workdocs.model.DocumentMetadata.ReadOnly {
    override val id: Option[ResourceIdType] = scala
      .Option(impl.id())
      .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val creatorId: Option[IdType] = scala
      .Option(impl.creatorId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val parentFolderId: Option[ResourceIdType] = scala
      .Option(impl.parentFolderId())
      .map(value => zio.aws.workdocs.model.primitives.ResourceIdType(value))
    override val createdTimestamp: Option[TimestampType] = scala
      .Option(impl.createdTimestamp())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val modifiedTimestamp: Option[TimestampType] = scala
      .Option(impl.modifiedTimestamp())
      .map(value => zio.aws.workdocs.model.primitives.TimestampType(value))
    override val latestVersionMetadata
        : Option[zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly] =
      scala
        .Option(impl.latestVersionMetadata())
        .map(value =>
          zio.aws.workdocs.model.DocumentVersionMetadata.wrap(value)
        )
    override val resourceState
        : Option[zio.aws.workdocs.model.ResourceStateType] = scala
      .Option(impl.resourceState())
      .map(value => zio.aws.workdocs.model.ResourceStateType.wrap(value))
    override val labels: Option[List[SharedLabel]] = scala
      .Option(impl.labels())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workdocs.model.primitives.SharedLabel(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DocumentMetadata
  ): zio.aws.workdocs.model.DocumentMetadata.ReadOnly = new Wrapper(impl)
}
