package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  DocumentVersionIdType,
  CustomMetadataValueType,
  AuthenticationHeaderType,
  ResourceIdType,
  CustomMetadataKeyType
}
import scala.jdk.CollectionConverters.*
final case class CreateCustomMetadataRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    resourceId: ResourceIdType,
    versionId: Option[DocumentVersionIdType] = None,
    customMetadata: Map[CustomMetadataKeyType, CustomMetadataValueType]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataRequest = {
    import CreateCustomMetadataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .resourceId(ResourceIdType.unwrap(resourceId): java.lang.String)
      .optionallyWith(
        versionId.map(value =>
          DocumentVersionIdType.unwrap(value): java.lang.String
        )
      )(_.versionId)
      .customMetadata(
        customMetadata
          .map({ case (key, value) =>
            (CustomMetadataKeyType
              .unwrap(key): java.lang.String) -> (CustomMetadataValueType
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.CreateCustomMetadataRequest.ReadOnly =
    zio.aws.workdocs.model.CreateCustomMetadataRequest.wrap(buildAwsValue())
}
object CreateCustomMetadataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.CreateCustomMetadataRequest =
      zio.aws.workdocs.model.CreateCustomMetadataRequest(
        authenticationToken.map(value => value),
        resourceId,
        versionId.map(value => value),
        customMetadata
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def resourceId: ResourceIdType
    def versionId: Option[DocumentVersionIdType]
    def customMetadata: Map[CustomMetadataKeyType, CustomMetadataValueType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getResourceId: ZIO[Any, Nothing, ResourceIdType] =
      ZIO.succeed(resourceId)
    def getVersionId: ZIO[Any, AwsError, DocumentVersionIdType] =
      AwsError.unwrapOptionField("versionId", versionId)
    def getCustomMetadata: ZIO[Any, Nothing, Map[
      CustomMetadataKeyType,
      CustomMetadataValueType
    ]] = ZIO.succeed(customMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataRequest
  ) extends zio.aws.workdocs.model.CreateCustomMetadataRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val resourceId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.resourceId())
    override val versionId: Option[DocumentVersionIdType] = scala
      .Option(impl.versionId())
      .map(value =>
        zio.aws.workdocs.model.primitives.DocumentVersionIdType(value)
      )
    override val customMetadata
        : Map[CustomMetadataKeyType, CustomMetadataValueType] = impl
      .customMetadata()
      .asScala
      .map({ case (key, value) =>
        zio.aws.workdocs.model.primitives.CustomMetadataKeyType(
          key
        ) -> zio.aws.workdocs.model.primitives.CustomMetadataValueType(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.CreateCustomMetadataRequest
  ): zio.aws.workdocs.model.CreateCustomMetadataRequest.ReadOnly = new Wrapper(
    impl
  )
}
