package zio.aws.workdocs.model
import scala.jdk.CollectionConverters.*
sealed trait BooleanEnumType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.BooleanEnumType
}
object BooleanEnumType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.BooleanEnumType
  ): zio.aws.workdocs.model.BooleanEnumType = value match {
    case software.amazon.awssdk.services.workdocs.model.BooleanEnumType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.BooleanEnumType.TRUE =>
      val r = TRUE
      r
    case software.amazon.awssdk.services.workdocs.model.BooleanEnumType.FALSE =>
      val r = FALSE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.BooleanEnumType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.BooleanEnumType =
      software.amazon.awssdk.services.workdocs.model.BooleanEnumType.UNKNOWN_TO_SDK_VERSION
  }
  case object TRUE extends zio.aws.workdocs.model.BooleanEnumType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.BooleanEnumType =
      software.amazon.awssdk.services.workdocs.model.BooleanEnumType.TRUE
  }
  case object FALSE extends zio.aws.workdocs.model.BooleanEnumType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.BooleanEnumType =
      software.amazon.awssdk.services.workdocs.model.BooleanEnumType.FALSE
  }
}
