package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.PageMarkerType
import scala.jdk.CollectionConverters.*
final case class DescribeDocumentVersionsResponse(
    documentVersions: Option[
      Iterable[zio.aws.workdocs.model.DocumentVersionMetadata]
    ] = None,
    marker: Option[PageMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse = {
    import DescribeDocumentVersionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse
      .builder()
      .optionallyWith(
        documentVersions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.documentVersions)
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly
      : zio.aws.workdocs.model.DescribeDocumentVersionsResponse.ReadOnly =
    zio.aws.workdocs.model.DescribeDocumentVersionsResponse
      .wrap(buildAwsValue())
}
object DescribeDocumentVersionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.DescribeDocumentVersionsResponse =
      zio.aws.workdocs.model.DescribeDocumentVersionsResponse(
        documentVersions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        marker.map(value => value)
      )
    def documentVersions
        : Option[List[zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly]]
    def marker: Option[PageMarkerType]
    def getDocumentVersions: ZIO[Any, AwsError, List[
      zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("documentVersions", documentVersions)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse
  ) extends zio.aws.workdocs.model.DescribeDocumentVersionsResponse.ReadOnly {
    override val documentVersions: Option[
      List[zio.aws.workdocs.model.DocumentVersionMetadata.ReadOnly]
    ] = scala
      .Option(impl.documentVersions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.workdocs.model.DocumentVersionMetadata.wrap(item)
        }.toList
      )
    override val marker: Option[PageMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.DescribeDocumentVersionsResponse
  ): zio.aws.workdocs.model.DescribeDocumentVersionsResponse.ReadOnly =
    new Wrapper(impl)
}
