package zio.aws.workdocs.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceStateType {
  def unwrap: software.amazon.awssdk.services.workdocs.model.ResourceStateType
}
object ResourceStateType {
  def wrap(
      value: software.amazon.awssdk.services.workdocs.model.ResourceStateType
  ): zio.aws.workdocs.model.ResourceStateType = value match {
    case software.amazon.awssdk.services.workdocs.model.ResourceStateType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.workdocs.model.ResourceStateType.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.workdocs.model.ResourceStateType.RESTORING =>
      val r = RESTORING
      r
    case software.amazon.awssdk.services.workdocs.model.ResourceStateType.RECYCLING =>
      val r = RECYCLING
      r
    case software.amazon.awssdk.services.workdocs.model.ResourceStateType.RECYCLED =>
      val r = RECYCLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.workdocs.model.ResourceStateType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResourceStateType =
      software.amazon.awssdk.services.workdocs.model.ResourceStateType.UNKNOWN_TO_SDK_VERSION
  }
  case object ACTIVE extends zio.aws.workdocs.model.ResourceStateType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResourceStateType =
      software.amazon.awssdk.services.workdocs.model.ResourceStateType.ACTIVE
  }
  case object RESTORING extends zio.aws.workdocs.model.ResourceStateType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResourceStateType =
      software.amazon.awssdk.services.workdocs.model.ResourceStateType.RESTORING
  }
  case object RECYCLING extends zio.aws.workdocs.model.ResourceStateType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResourceStateType =
      software.amazon.awssdk.services.workdocs.model.ResourceStateType.RECYCLING
  }
  case object RECYCLED extends zio.aws.workdocs.model.ResourceStateType {
    override def unwrap
        : software.amazon.awssdk.services.workdocs.model.ResourceStateType =
      software.amazon.awssdk.services.workdocs.model.ResourceStateType.RECYCLED
  }
}
