package zio.aws.workdocs.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  PageMarkerType,
  LimitType,
  IdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class GetResourcesRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    userId: Option[IdType] = None,
    collectionType: Option[zio.aws.workdocs.model.ResourceCollectionType] =
      None,
    limit: Option[LimitType] = None,
    marker: Option[PageMarkerType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GetResourcesRequest = {
    import GetResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GetResourcesRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .optionallyWith(
        userId.map(value => IdType.unwrap(value): java.lang.String)
      )(_.userId)
      .optionallyWith(collectionType.map(value => value.unwrap))(
        _.collectionType
      )
      .optionallyWith(limit.map(value => LimitType.unwrap(value): Integer))(
        _.limit
      )
      .optionallyWith(
        marker.map(value => PageMarkerType.unwrap(value): java.lang.String)
      )(_.marker)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GetResourcesRequest.ReadOnly =
    zio.aws.workdocs.model.GetResourcesRequest.wrap(buildAwsValue())
}
object GetResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GetResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GetResourcesRequest =
      zio.aws.workdocs.model.GetResourcesRequest(
        authenticationToken.map(value => value),
        userId.map(value => value),
        collectionType.map(value => value),
        limit.map(value => value),
        marker.map(value => value)
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def userId: Option[IdType]
    def collectionType: Option[zio.aws.workdocs.model.ResourceCollectionType]
    def limit: Option[LimitType]
    def marker: Option[PageMarkerType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getUserId: ZIO[Any, AwsError, IdType] =
      AwsError.unwrapOptionField("userId", userId)
    def getCollectionType
        : ZIO[Any, AwsError, zio.aws.workdocs.model.ResourceCollectionType] =
      AwsError.unwrapOptionField("collectionType", collectionType)
    def getLimit: ZIO[Any, AwsError, LimitType] =
      AwsError.unwrapOptionField("limit", limit)
    def getMarker: ZIO[Any, AwsError, PageMarkerType] =
      AwsError.unwrapOptionField("marker", marker)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GetResourcesRequest
  ) extends zio.aws.workdocs.model.GetResourcesRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val userId: Option[IdType] = scala
      .Option(impl.userId())
      .map(value => zio.aws.workdocs.model.primitives.IdType(value))
    override val collectionType
        : Option[zio.aws.workdocs.model.ResourceCollectionType] = scala
      .Option(impl.collectionType())
      .map(value => zio.aws.workdocs.model.ResourceCollectionType.wrap(value))
    override val limit: Option[LimitType] = scala
      .Option(impl.limit())
      .map(value => zio.aws.workdocs.model.primitives.LimitType(value))
    override val marker: Option[PageMarkerType] = scala
      .Option(impl.marker())
      .map(value => zio.aws.workdocs.model.primitives.PageMarkerType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GetResourcesRequest
  ): zio.aws.workdocs.model.GetResourcesRequest.ReadOnly = new Wrapper(impl)
}
