package zio.aws.workdocs.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.workdocs.model.primitives.{
  BooleanType,
  ResourceIdType,
  AuthenticationHeaderType
}
import scala.jdk.CollectionConverters.*
final case class GetFolderRequest(
    authenticationToken: Option[AuthenticationHeaderType] = None,
    folderId: ResourceIdType,
    includeCustomMetadata: Option[BooleanType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.workdocs.model.GetFolderRequest = {
    import GetFolderRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.workdocs.model.GetFolderRequest
      .builder()
      .optionallyWith(
        authenticationToken.map(value =>
          AuthenticationHeaderType.unwrap(value): java.lang.String
        )
      )(_.authenticationToken)
      .folderId(ResourceIdType.unwrap(folderId): java.lang.String)
      .optionallyWith(
        includeCustomMetadata.map(value =>
          BooleanType.unwrap(value): java.lang.Boolean
        )
      )(_.includeCustomMetadata)
      .build()
  }
  def asReadOnly: zio.aws.workdocs.model.GetFolderRequest.ReadOnly =
    zio.aws.workdocs.model.GetFolderRequest.wrap(buildAwsValue())
}
object GetFolderRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.workdocs.model.GetFolderRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.workdocs.model.GetFolderRequest =
      zio.aws.workdocs.model.GetFolderRequest(
        authenticationToken.map(value => value),
        folderId,
        includeCustomMetadata.map(value => value)
      )
    def authenticationToken: Option[AuthenticationHeaderType]
    def folderId: ResourceIdType
    def includeCustomMetadata: Option[BooleanType]
    def getAuthenticationToken: ZIO[Any, AwsError, AuthenticationHeaderType] =
      AwsError.unwrapOptionField("authenticationToken", authenticationToken)
    def getFolderId: ZIO[Any, Nothing, ResourceIdType] = ZIO.succeed(folderId)
    def getIncludeCustomMetadata: ZIO[Any, AwsError, BooleanType] =
      AwsError.unwrapOptionField("includeCustomMetadata", includeCustomMetadata)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.workdocs.model.GetFolderRequest
  ) extends zio.aws.workdocs.model.GetFolderRequest.ReadOnly {
    override val authenticationToken: Option[AuthenticationHeaderType] = scala
      .Option(impl.authenticationToken())
      .map(value =>
        zio.aws.workdocs.model.primitives.AuthenticationHeaderType(value)
      )
    override val folderId: ResourceIdType =
      zio.aws.workdocs.model.primitives.ResourceIdType(impl.folderId())
    override val includeCustomMetadata: Option[BooleanType] = scala
      .Option(impl.includeCustomMetadata())
      .map(value => zio.aws.workdocs.model.primitives.BooleanType(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.workdocs.model.GetFolderRequest
  ): zio.aws.workdocs.model.GetFolderRequest.ReadOnly = new Wrapper(impl)
}
